/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence.migration;

import de.retest.recheck.persistence.migration.XmlTransformer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class ReplaceAttributeTransformer
extends XmlTransformer {
    private final String tagname;
    private final String attributeName;
    private final String value;
    private final String newValue;

    public ReplaceAttributeTransformer(String tagname, String attributeName, String value, String newValue) {
        this.tagname = tagname;
        this.attributeName = attributeName;
        this.value = value;
        this.newValue = newValue;
    }

    @Override
    public void reset() {
    }

    @Override
    public void convert(XMLEvent event, XMLEventWriter eventWriter) throws XMLStreamException {
        if (this.isStartElementNamed(event, this.tagname)) {
            StartElement startElement = event.asStartElement();
            eventWriter.add(this.newline());
            eventWriter.add(this.eventFactory.createStartElement(startElement.getName(), this.convertAttributes(startElement.getAttributes()), startElement.getNamespaces()));
            return;
        }
        eventWriter.add(event);
    }

    private Iterator<Attribute> convertAttributes(Iterator<Attribute> attributes) {
        ArrayList<Attribute> newAttributes = new ArrayList<Attribute>();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            String name = attribute.getName().getLocalPart();
            if (name.equals(this.attributeName) && attribute.getValue().matches(this.value)) {
                newAttributes.add(this.eventFactory.createAttribute(attribute.getName(), this.newValue));
                continue;
            }
            newAttributes.add(attribute);
        }
        return newAttributes.iterator();
    }
}

