/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence.migration;

import de.retest.recheck.persistence.migration.ReplaceAttributeTransformer;
import de.retest.recheck.persistence.migration.XmlMigratorInstances;
import de.retest.recheck.persistence.migration.XmlTransformer;
import de.retest.recheck.persistence.xml.util.XmlVersionCheckResult;
import de.retest.recheck.util.NamedBufferedInputStream;
import de.retest.recheck.util.ThreadUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlMigrator {
    private static final Logger logger = LoggerFactory.getLogger(XmlMigrator.class);

    public static NamedBufferedInputStream tryToMigrate(XmlVersionCheckResult checkResult, NamedBufferedInputStream bin) {
        XmlMigratorInstances migrator = XmlMigratorInstances.get(checkResult.oldDataType);
        InputStream finalInputStream = bin;
        if (migrator != null) {
            if (!ThreadUtil.stackTraceContainsClass("de.retest.migration.TestMigrator") && !ThreadUtil.stackTraceContainsClass("de.retest.TestMigrator")) {
                logger.warn("********************************************************************************");
                logger.warn("ReTest detected an old version of the file '{}'.", (Object)bin.getName());
                logger.warn("ReTest migrates the file now, but will discard the results to avoid VCS file conflicts.");
                logger.warn("It is very recommended to locally convert the file and commit it to speed up execution!");
                logger.warn("********************************************************************************");
            }
            logger.info("Migrating file '{}' from version {} to version {}. This may take a while.", new Object[]{bin.getName(), checkResult.oldVersion, checkResult.newDataTypeInstance.version()});
            ArrayList<XmlTransformer> transformers = new ArrayList<XmlTransformer>();
            transformers.addAll(XmlMigrator.createRemoveDatatypeAndVersionTransformer(checkResult.oldDataType, Integer.toString(checkResult.newDataTypeInstance.version())));
            transformers.addAll(migrator.getXmlTransformersFor(checkResult.oldVersion));
            for (int i = 0; i < transformers.size(); ++i) {
                boolean notFinalInputStream = i < transformers.size() - 1;
                NamedBufferedInputStream previousInputStream = finalInputStream;
                finalInputStream = ((XmlTransformer)transformers.get(i)).transform(finalInputStream);
                if (!notFinalInputStream) continue;
                try {
                    ((InputStream)previousInputStream).close();
                    continue;
                }
                catch (IOException e) {
                    logger.error("Error closing previous input stream during migration.", (Throwable)e);
                }
            }
            logger.info("Migrated file '{}' from version {} to version {}.", new Object[]{bin.getName(), checkResult.oldVersion, checkResult.newDataTypeInstance.version()});
            return new NamedBufferedInputStream(finalInputStream, bin.getName());
        }
        return XmlMigrator.throwUnableToMigrateException(checkResult);
    }

    protected static List<XmlTransformer> createRemoveDatatypeAndVersionTransformer(String dataType, String dataTypeVersion) {
        ArrayList<XmlTransformer> result = new ArrayList<XmlTransformer>();
        result.add(new ReplaceAttributeTransformer("reTestXmlDataContainer", "dataType", ".*", dataType));
        result.add(new ReplaceAttributeTransformer("reTestXmlDataContainer", "dataTypeVersion", ".*", dataTypeVersion));
        return result;
    }

    private static NamedBufferedInputStream throwUnableToMigrateException(XmlVersionCheckResult checkResult) {
        throw new RuntimeException("Unexpected data version, version in XML file=" + checkResult.oldVersion + ", version in the corresponding class=" + checkResult.newDataTypeInstance.version());
    }
}

