/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence.migration.transformers;

import de.retest.recheck.persistence.migration.XmlTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class AddRetestIdTestTransformer
extends XmlTransformer {
    private final RetestIdCreator idCreator;

    public AddRetestIdTestTransformer() {
        this(new RetestIdCreator());
    }

    public AddRetestIdTestTransformer(RetestIdCreator idCreator) {
        this.idCreator = idCreator;
    }

    @Override
    protected void reset() {
    }

    @Override
    public void convert(XMLEvent event, XMLEventWriter eventWriter) throws XMLStreamException {
        if (this.isStartElementNamed(event, "targetcomponent")) {
            eventWriter.add(this.startElementNamed("targetcomponent", this.attribute("retestId", this.idCreator.retestId())));
            return;
        }
        if (this.isStartElementNamed(event, "element")) {
            eventWriter.add(this.startElementNamed("element", this.attribute("retestId", this.idCreator.retestId())));
            return;
        }
        if (this.isStartElementNamed(event, "bestMatch")) {
            eventWriter.add(this.startElementNamed("bestMatch", this.attribute("retestId", this.idCreator.retestId())));
            return;
        }
        if (this.isStartElementNamed(event, "containedComponents")) {
            eventWriter.add(this.startElementNamed("containedComponents", this.attribute("retestId", this.idCreator.retestId())));
            return;
        }
        if (this.isStartElementNamed(event, "descriptors")) {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            attributes.add(this.attribute("retestId", this.idCreator.retestId()));
            attributes.addAll(this.toList(event.asStartElement().getAttributes()));
            eventWriter.add(this.startElementNamed("descriptors", attributes.iterator()));
            return;
        }
        eventWriter.add(event);
    }

    private Collection<Attribute> toList(Iterator<Attribute> attributes) {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        attributes.forEachRemaining(list::add);
        return list;
    }

    public static class RetestIdCreator {
        public String retestId() {
            return UUID.randomUUID().toString();
        }
    }
}

