/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence.migration.transformers;

import de.retest.recheck.persistence.migration.XmlTransformer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class Path2XPathTransformer
extends XmlTransformer {
    private static final Pattern countBeforeSeparator = Pattern.compile("_([0-9]+)(\\/|\\z){1}");
    private boolean isInPath;
    private String path = "";
    private boolean isInSuffix;
    private String suffix = "";

    @Override
    protected void reset() {
        this.isInPath = false;
        this.path = "";
        this.isInSuffix = false;
        this.suffix = "";
    }

    @Override
    public void convert(XMLEvent event, XMLEventWriter eventWriter) throws XMLStreamException {
        if (this.isStartElementNamed(event, "attribute") && this.hasAttribute(event, "key", "path")) {
            this.isInPath = true;
        }
        if (this.isInPath && event.isCharacters()) {
            this.path = this.path + event.asCharacters().getData().trim();
            return;
        }
        if (this.isInPath && this.isEndElementNamed(event, "attribute")) {
            eventWriter.add(this.characters(Path2XPathTransformer.toXPath(this.path)));
            this.isInPath = false;
            this.path = "";
        }
        if (this.isStartElementNamed(event, "attribute") && this.hasAttribute(event, "key", "suffix")) {
            this.isInSuffix = true;
        }
        if (this.isInSuffix && event.isCharacters()) {
            this.suffix = this.suffix + event.asCharacters().getData().trim();
            return;
        }
        if (this.isEndElementNamed(event, "attribute")) {
            try {
                eventWriter.add(this.characters(String.valueOf(Integer.parseInt(this.suffix) + 1)));
            }
            catch (NumberFormatException exc) {
                eventWriter.add(this.characters(this.suffix));
            }
            this.isInSuffix = false;
            this.suffix = "";
        }
        eventWriter.add(event);
    }

    protected static String toXPath(String path) {
        String result = path;
        Matcher matcher = countBeforeSeparator.matcher(result);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "[" + String.valueOf(Integer.parseInt(matcher.group(1)) + 1) + "]" + matcher.group(2));
        }
        matcher.appendTail(sb);
        result = sb.toString();
        result = result.replaceAll("popup_([^\\/]+)(\\/|\\z){1}", "popup_$1[1]$2");
        return result;
    }
}

