/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence.xml;

import com.google.common.collect.ImmutableMap;
import de.retest.recheck.persistence.xml.util.SessionLogDelegate;
import de.retest.recheck.persistence.xml.util.StdXmlClassesProvider;
import de.retest.recheck.persistence.xml.util.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.persistence.internal.oxm.record.namespaces.MapNamespacePrefixMapper;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlTransformer {
    private static final Logger logger = LoggerFactory.getLogger(XmlTransformer.class);
    private static final ImmutableMap<String, String> NAMESPACE_MAPPINGS = ImmutableMap.of((Object)"http://www.w3.org/2001/XMLSchema", (Object)"xsd", (Object)"http://www.w3.org/2001/XMLSchema-instance", (Object)"xsi");
    private final XmlTransformerConfig[] config;
    private final JAXBContext jc;
    private static final Set<Marshaller> lightweightMarshallerSet = new HashSet<Marshaller>();

    public XmlTransformer(Class<?>[] additionalClazzes, XmlTransformerConfig ... config) {
        this.config = config;
        this.jc = this.createJAXBContext(additionalClazzes);
    }

    public XmlTransformer(XmlTransformerConfig config, Class<?> ... additionalClazzes) {
        this(additionalClazzes, config);
    }

    public XmlTransformer(Class<?> ... additionalClazzes) {
        this(additionalClazzes, new XmlTransformerConfig[0]);
    }

    public XmlTransformer(XmlTransformerConfig config, Set<Class<?>> xmlDataClasses) {
        this(config, xmlDataClasses.toArray(new Class[xmlDataClasses.size()]));
    }

    public XmlTransformer(Set<Class<?>> xmlDataClasses) {
        this(null, xmlDataClasses);
    }

    public <T> T fromXML(InputStream in) {
        return this.fromXML(in, null);
    }

    public <T> T fromXML(InputStream in, Unmarshaller.Listener listener) {
        try {
            Unmarshaller unmarshaller = this.jc.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            unmarshaller.setListener(listener);
            Object result = unmarshaller.unmarshal(in);
            return (T)result;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isLightweightMarshaller(Marshaller m) {
        return lightweightMarshallerSet.contains(m);
    }

    public void toXML(Object obj, OutputStream out, Marshaller.Listener listener) {
        Marshaller marshaller = null;
        try {
            marshaller = this.jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("eclipselink.namespace-prefix-mapper", (Object)new MapNamespacePrefixMapper(NAMESPACE_MAPPINGS));
            marshaller.setProperty("eclipselink.indent-string", (Object)"\t");
            marshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            marshaller.setListener(listener);
            SessionLogDelegate sessionLog = new SessionLogDelegate(AbstractSessionLog.getLog());
            AbstractSessionLog.setLog((SessionLog)sessionLog);
            if (ArrayUtils.contains((Object[])this.config, (Object)((Object)XmlTransformerConfig.CREATE_ONLY_FRAGMENT))) {
                logger.info("Create only fragment for '{}'.", obj);
                marshaller.setProperty("jaxb.fragment", (Object)true);
            }
            if (ArrayUtils.contains((Object[])this.config, (Object)((Object)XmlTransformerConfig.USE_LIGHTWEIGHT_XML))) {
                logger.info("Use lightweight xml for '{}'.", obj);
                lightweightMarshallerSet.add(marshaller);
                XmlUtil.addLightWeightAdapter(marshaller);
            }
            marshaller.marshal(obj, out);
            if (sessionLog.containsMessages()) {
                throw new RuntimeException("Error persisting xml: " + sessionLog.getLog());
            }
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ArrayUtils.contains((Object[])this.config, (Object)((Object)XmlTransformerConfig.USE_LIGHTWEIGHT_XML)) && marshaller != null) {
                lightweightMarshallerSet.remove(marshaller);
            }
        }
    }

    public void toXML(Object obj, OutputStream out) {
        this.toXML(obj, out, null);
    }

    public String toXML(Object obj) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.toXML(obj, ps);
        return baos.toString();
    }

    private JAXBContext createJAXBContext(Class<?> ... additionalClazzes) {
        try {
            Class[] contextClasses = StdXmlClassesProvider.getXmlDataClasses(additionalClazzes);
            return JAXBContextFactory.createContext((Class[])contextClasses, Collections.emptyMap());
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum XmlTransformerConfig {
        USE_LIGHTWEIGHT_XML,
        CREATE_ONLY_FRAGMENT;

    }
}

