/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence.xml.util;

import de.retest.recheck.persistence.Persistable;
import de.retest.recheck.persistence.xml.ReTestXmlDataContainer;
import de.retest.recheck.util.ReflectionUtilities;
import java.io.BufferedInputStream;
import java.io.IOException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XmlVersionCheckResult {
    private static final XMLInputFactory FACTORY = XMLInputFactory.newInstance();
    public final int oldVersion;
    public final String oldDataType;
    public final Persistable newDataTypeInstance;

    private XmlVersionCheckResult(String dataType, int version) {
        this.oldVersion = version;
        this.oldDataType = dataType;
        this.newDataTypeInstance = ReflectionUtilities.createNewInstanceOrNull(Persistable.class, dataType);
    }

    public static XmlVersionCheckResult create(BufferedInputStream in) throws IOException {
        in.mark(18192);
        XMLStreamReader parser = XmlVersionCheckResult.createParserAndPointItToRootXmlElement(in);
        XmlVersionCheckResult.preventLoadingOfOutdatedFile(parser);
        XmlVersionCheckResult.ensureThatContainerIsRootElement(parser);
        XmlVersionCheckResult checkResult = XmlVersionCheckResult.extractCheckResultValuesFromXml(parser);
        in.reset();
        return checkResult;
    }

    private static XMLStreamReader createParserAndPointItToRootXmlElement(BufferedInputStream in) {
        try {
            XMLStreamReader parser = FACTORY.createXMLStreamReader(in);
            parser.next();
            return parser;
        }
        catch (XMLStreamException e) {
            throw new IllegalArgumentException("The input don't look like valid retest XML content!", e);
        }
    }

    private static void preventLoadingOfOutdatedFile(XMLStreamReader parser) {
        if (parser.getEventType() == 5 && parser.getText().contains("Serialized with ReTest")) {
            throw new IllegalArgumentException("This file looks like outdated retest XML file, please call support to update!");
        }
    }

    private static void ensureThatContainerIsRootElement(XMLStreamReader parser) {
        while (parser.getEventType() == 5) {
            try {
                parser.next();
            }
            catch (XMLStreamException exc) {
                throw new RuntimeException(exc);
            }
        }
        if (!ReTestXmlDataContainer.class.getSimpleName().equalsIgnoreCase(parser.getName().toString())) {
            throw new IllegalArgumentException("This file doesn't look like a retest XML file, unexpected first tag in XML: " + parser.getName().toString());
        }
    }

    private static XmlVersionCheckResult extractCheckResultValuesFromXml(XMLStreamReader parser) {
        int version;
        String dataType;
        try {
            dataType = parser.getAttributeValue(null, "dataType");
            String versionString = parser.getAttributeValue(null, "dataTypeVersion");
            version = Integer.parseInt(versionString);
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException("Invalid XML document!", e);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid XML document!", e);
        }
        return new XmlVersionCheckResult(dataType, version);
    }

    public boolean isCompatible() {
        return this.newDataTypeInstance != null && this.newDataTypeInstance.version() == this.oldVersion;
    }
}

