/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.printer;

import de.retest.recheck.NoRecheckFileActionReplayResult;
import de.retest.recheck.ignore.ShouldIgnore;
import de.retest.recheck.printer.ElementDifferencePrinter;
import de.retest.recheck.printer.Printer;
import de.retest.recheck.report.ActionReplayResult;
import de.retest.recheck.ui.DefaultValueFinder;
import de.retest.recheck.ui.actions.ExceptionWrapper;
import de.retest.recheck.ui.diff.ElementDifference;
import java.util.stream.Collectors;

public class ActionReplayResultPrinter
implements Printer<ActionReplayResult> {
    private final ElementDifferencePrinter printer;
    private final ShouldIgnore ignore;

    public ActionReplayResultPrinter(DefaultValueFinder defaultValueFinder, ShouldIgnore ignore) {
        this.printer = new ElementDifferencePrinter(defaultValueFinder, ignore);
        this.ignore = ignore;
    }

    @Override
    public String toString(ActionReplayResult difference, String indent) {
        String prefix = indent + this.createDescription(difference) + "\n";
        String nextIndent = indent + "\t";
        ExceptionWrapper error = difference.getThrowableWrapper();
        if (error != null) {
            return prefix + nextIndent + error;
        }
        Throwable targetNotFound = difference.getTargetNotFoundException();
        if (targetNotFound != null) {
            return prefix + nextIndent + targetNotFound;
        }
        if (difference instanceof NoRecheckFileActionReplayResult) {
            return prefix + nextIndent + "No recheck file found. First time test was run? Created recheck file now, don't forget to commit...";
        }
        return prefix + this.createDifferences(difference, nextIndent);
    }

    private String createDescription(ActionReplayResult difference) {
        return difference.getDescription() + " resulted in:";
    }

    private String createDifferences(ActionReplayResult difference, String indent) {
        return difference.getAllElementDifferences().stream().filter(diff -> !this.ignore.shouldIgnoreElement(diff.getElement())).filter(diff -> !diff.getAttributeDifferences(this.ignore).isEmpty()).map(diff -> this.printer.toString((ElementDifference)diff, indent)).collect(Collectors.joining("\n"));
    }
}

