/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.printer;

import de.retest.recheck.printer.Printer;
import de.retest.recheck.ui.DefaultValueFinder;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.diff.AttributeDifference;
import java.io.Serializable;

public class AttributeDifferencePrinter
implements Printer<AttributeDifference> {
    private static final String IS_DEFAULT = "(default)";
    private static final String KEY_EXPECTED_ACTUAL_FORMAT = "%s: expected=\"%s\", actual=\"%s\"";
    private final IdentifyingAttributes attributes;
    private final DefaultValueFinder defaultProvider;

    public AttributeDifferencePrinter(IdentifyingAttributes attributes, DefaultValueFinder finder) {
        this.attributes = attributes;
        this.defaultProvider = finder;
    }

    @Override
    public String toString(AttributeDifference difference, String indent) {
        return indent + this.format(difference);
    }

    private String format(AttributeDifference difference) {
        if (this.isExpectedDefault(difference)) {
            return this.printExpectedDefaultDifference(difference);
        }
        if (this.isActualDefault(difference)) {
            return this.printActualDefaultDifference(difference);
        }
        return this.printBothDifferences(difference);
    }

    private boolean isActualDefault(AttributeDifference difference) {
        return this.defaultProvider.isDefaultValue(this.attributes, difference.getKey(), difference.getActual());
    }

    private String printActualDefaultDifference(AttributeDifference difference) {
        String key = difference.getKey();
        Serializable expected = difference.getExpected();
        return String.format(KEY_EXPECTED_ACTUAL_FORMAT, key, expected, IS_DEFAULT);
    }

    private boolean isExpectedDefault(AttributeDifference difference) {
        return difference.getExpected() == null;
    }

    private String printExpectedDefaultDifference(AttributeDifference difference) {
        String key = difference.getKey();
        Serializable actual = difference.getActual();
        return String.format(KEY_EXPECTED_ACTUAL_FORMAT, key, IS_DEFAULT, actual);
    }

    private String printBothDifferences(AttributeDifference difference) {
        String key = difference.getKey();
        Serializable expected = difference.getExpected();
        Serializable actual = difference.getActual();
        return String.format(KEY_EXPECTED_ACTUAL_FORMAT, key, expected, actual);
    }
}

