/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.printer;

import de.retest.recheck.ignore.ShouldIgnore;
import de.retest.recheck.printer.AttributeDifferencePrinter;
import de.retest.recheck.printer.Printer;
import de.retest.recheck.ui.DefaultValueFinder;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.ui.diff.ElementDifference;
import java.util.stream.Collectors;

public class ElementDifferencePrinter
implements Printer<ElementDifference> {
    private final DefaultValueFinder finder;
    private final ShouldIgnore ignore;

    public ElementDifferencePrinter(DefaultValueFinder finder, ShouldIgnore ignore) {
        this.finder = finder;
        this.ignore = ignore;
    }

    @Override
    public String toString(ElementDifference difference, String indent) {
        return indent + this.createDescription(difference) + "\n" + this.createDifferences(difference, indent + "\t");
    }

    private String createDescription(ElementDifference difference) {
        IdentifyingAttributes attributes = difference.getIdentifyingAttributes();
        return attributes + " at '" + attributes.getPath() + "':";
    }

    private String createDifferences(ElementDifference difference, String indent) {
        IdentifyingAttributes attributes = difference.getIdentifyingAttributes();
        AttributeDifferencePrinter delegate = new AttributeDifferencePrinter(attributes, this.finder);
        return difference.getAttributeDifferences(this.ignore).stream().map(d -> delegate.toString((AttributeDifference)d, indent)).collect(Collectors.joining("\n"));
    }
}

