/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.printer;

import de.retest.recheck.ignore.ShouldIgnore;
import de.retest.recheck.printer.ActionReplayResultPrinter;
import de.retest.recheck.printer.DefaultValueFinderProvider;
import de.retest.recheck.printer.Printer;
import de.retest.recheck.report.ActionReplayResult;
import de.retest.recheck.report.TestReplayResult;
import de.retest.recheck.ui.DefaultValueFinder;
import java.util.stream.Collectors;

public class TestReplayResultPrinter
implements Printer<TestReplayResult> {
    private final DefaultValueFinderProvider provider;
    private final ShouldIgnore ignore;

    public TestReplayResultPrinter(DefaultValueFinderProvider provider, ShouldIgnore ignore) {
        this.provider = provider;
        this.ignore = ignore;
    }

    @Override
    public String toString(TestReplayResult difference, String indent) {
        return indent + this.createDescription(difference) + "\n" + this.createDifferences(difference, indent);
    }

    private String createDescription(TestReplayResult result) {
        String name = result.getName();
        int differences = result.getDifferences(this.ignore).size();
        int states = result.getActionReplayResults().size();
        return String.format("Test '%s' has %d differences in %d states:", name, differences, states);
    }

    private String createDifferences(TestReplayResult difference, String indent) {
        return difference.getActionReplayResults().stream().map(a -> this.formatAction((ActionReplayResult)a, indent)).collect(Collectors.joining("\n"));
    }

    private String formatAction(ActionReplayResult result, String indent) {
        DefaultValueFinder finder = this.provider.findForAction(result.getDescription());
        ActionReplayResultPrinter printer = new ActionReplayResultPrinter(finder, this.ignore);
        return printer.toString(result, indent);
    }
}

