/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.report;

import de.retest.recheck.ignore.ShouldIgnore;
import de.retest.recheck.report.action.ActionReplayData;
import de.retest.recheck.report.action.DifferenceRetriever;
import de.retest.recheck.report.action.ErrorHolder;
import de.retest.recheck.report.action.WindowRetriever;
import de.retest.recheck.ui.actions.ActionState;
import de.retest.recheck.ui.actions.ExceptionWrapper;
import de.retest.recheck.ui.actions.TargetNotFoundException;
import de.retest.recheck.ui.actions.TargetNotFoundWrapper;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.RootElement;
import de.retest.recheck.ui.descriptors.SutState;
import de.retest.recheck.ui.diff.ElementDifference;
import de.retest.recheck.ui.diff.LeafDifference;
import de.retest.recheck.ui.diff.RootElementDifference;
import de.retest.recheck.ui.diff.StateDifference;
import de.retest.recheck.ui.image.Screenshot;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="action")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ActionReplayResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final long NO_DURATION = 0L;
    @XmlAttribute
    private final String description;
    private final String stateFilePath;
    @XmlElement
    private final Element targetcomponent;
    @XmlElement
    private final ExceptionWrapper error;
    @XmlElement
    private final TargetNotFoundWrapper targetNotFound;
    @XmlElement
    private final StateDifference stateDifference;
    @XmlAttribute
    private long duration;
    @XmlAttribute
    private final ExecutionType executionType;
    @XmlElement(name="window")
    @XmlElementWrapper(name="state")
    private final List<RootElement> windows;

    protected ActionReplayResult() {
        this.description = null;
        this.stateFilePath = null;
        this.targetcomponent = null;
        this.error = null;
        this.targetNotFound = null;
        this.stateDifference = null;
        this.windows = null;
        this.executionType = null;
    }

    public static ActionReplayResult createActionReplayResult(ActionReplayData data, ExceptionWrapper error, TargetNotFoundException targetNotFound, StateDifference difference, long actualDuration, SutState actualState) {
        if (error != null || targetNotFound != null) {
            return ActionReplayResult.withError(data, ErrorHolder.of(error, targetNotFound));
        }
        if (!difference.getRootElementDifferences().isEmpty()) {
            return ActionReplayResult.withDifference(data, WindowRetriever.empty(), DifferenceRetriever.of(difference), actualDuration);
        }
        return ActionReplayResult.withoutDifference(data, WindowRetriever.of(actualState), actualDuration);
    }

    public static ActionReplayResult withError(ActionReplayData data, ErrorHolder error) {
        return new ActionReplayResult(data, WindowRetriever.empty(), error, DifferenceRetriever.empty(), 0L, null);
    }

    public static ActionReplayResult withDifference(ActionReplayData data, WindowRetriever windows, DifferenceRetriever difference, long duration) {
        return new ActionReplayResult(data, windows, ErrorHolder.empty(), difference, duration, null);
    }

    public static ActionReplayResult withoutDifference(ActionReplayData data, WindowRetriever windows, long duration) {
        return ActionReplayResult.withDifference(data, windows, DifferenceRetriever.empty(), duration);
    }

    public static ActionReplayResult insertion(ActionState actionState) {
        return new ActionReplayResult(ActionReplayData.of(actionState.getAction()), WindowRetriever.of(actionState), ErrorHolder.empty(), DifferenceRetriever.empty(), actionState.getDuration(), ExecutionType.INSERTION);
    }

    public static ActionReplayResult deletion(ActionState actionState) {
        return new ActionReplayResult(ActionReplayData.of(actionState.getAction()), WindowRetriever.of(actionState), ErrorHolder.empty(), DifferenceRetriever.empty(), 0L, ExecutionType.DELETION);
    }

    protected ActionReplayResult(ActionReplayData data, WindowRetriever windows, ErrorHolder error, DifferenceRetriever difference, long duration, ExecutionType executionType) {
        if (windows.isNull() && difference.isNull() && !error.hasError()) {
            throw new NullPointerException("ActionReplayResult must not be empty! Affected action: " + data.getDescription() + ".");
        }
        this.description = data.getDescription();
        this.stateFilePath = data.getStateFilePath();
        this.targetcomponent = data.getElement();
        this.windows = (List)windows.get();
        this.error = error.getThrowableWrapper();
        this.targetNotFound = error.getTargetNotFoundWrapper();
        this.stateDifference = (StateDifference)difference.get();
        this.duration = duration;
        this.executionType = executionType;
    }

    public Throwable getThrowable() {
        return this.error == null ? null : this.error.getThrowable();
    }

    public ExceptionWrapper getThrowableWrapper() {
        return this.error;
    }

    public Throwable getTargetNotFoundException() {
        return this.targetNotFound == null ? null : this.targetNotFound.getTargetNotFoundException();
    }

    public TargetNotFoundWrapper getTargetNotFoundWrapper() {
        return this.targetNotFound;
    }

    public StateDifference getStateDifference() {
        return this.stateDifference;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getDescription() {
        return this.description;
    }

    public String getStateFilePath() {
        return this.stateFilePath;
    }

    public List<ElementDifference> getAllElementDifferences() {
        ArrayList<ElementDifference> differences = new ArrayList<ElementDifference>();
        if (this.stateDifference != null) {
            differences.addAll(this.stateDifference.getNonEmptyDifferences());
        }
        if (this.error != null) {
            // empty if block
        }
        return differences;
    }

    public Set<LeafDifference> getDifferences(ShouldIgnore ignore) {
        HashSet<LeafDifference> result = new HashSet<LeafDifference>();
        for (ElementDifference elementDifference : this.getAllElementDifferences()) {
            result.addAll(elementDifference.getAttributeDifferences(ignore));
        }
        return result;
    }

    public List<RootElement> getWindows() {
        return this.windows;
    }

    public Element getTargetComponent() {
        return this.targetcomponent;
    }

    public Screenshot getTargetScreenshot() {
        if (this.getTargetComponent() != null) {
            return this.getTargetComponent().getScreenshot();
        }
        return null;
    }

    public int getCheckedUiElementsCount() {
        if (!this.windows.isEmpty()) {
            int result = 0;
            for (RootElement rootElement : this.windows) {
                result += rootElement.countAllContainedElements();
            }
            return result;
        }
        if (this.stateDifference != null) {
            int result = 0;
            for (RootElementDifference rootElementDifference : this.stateDifference.getRootElementDifferences()) {
                result += rootElementDifference.getCheckedUiComponentCount();
            }
            return result;
        }
        return 0;
    }

    public boolean hasError() {
        return this.error != null || this.targetNotFound != null;
    }

    public boolean hasDifferences() {
        return this.stateDifference != null && this.stateDifference.size() > 0;
    }

    public boolean hasWindows() {
        return this.windows != null && this.windows.size() > 0;
    }

    public ExecutionType getExecutionType() {
        return this.executionType != null ? this.executionType : ExecutionType.NORMAL;
    }

    public String toString() {
        if (this.hasError()) {
            return "ActionReplayResult('" + this.description + "' has an error: " + (this.error != null ? this.error : this.targetNotFound) + ")";
        }
        return "ActionReplayResult('" + this.description + "' resulted in " + this.getAllElementDifferences().size() + " differences.)";
    }

    public static enum ExecutionType {
        NORMAL,
        INSERTION,
        DELETION;

    }
}

