/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.report;

import de.retest.recheck.ignore.GloballyIgnoredAttributes;
import de.retest.recheck.persistence.GoldenMasterSourceSuppressDefaultAdapter;
import de.retest.recheck.persistence.Persistable;
import de.retest.recheck.report.SuiteReplayResult;
import de.retest.recheck.ui.review.GoldenMasterSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="testreport")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ReplayResult
extends Persistable {
    private static final long serialVersionUID = 1L;
    private static final int PERSISTENCE_VERSION = 19;
    @XmlElement(name="suite")
    private final List<SuiteReplayResult> suiteReplayResults = new ArrayList<SuiteReplayResult>();
    @XmlAttribute
    @XmlJavaTypeAdapter(value=GoldenMasterSourceSuppressDefaultAdapter.class)
    private final GoldenMasterSource source;
    @XmlElement
    @XmlElementWrapper(name="ignoredAttributes")
    private final List<String> ignoredAttributes;

    public static ReplayResult fromApi(SuiteReplayResult newSuite) {
        return new ReplayResult(GoldenMasterSource.API, newSuite);
    }

    public ReplayResult() {
        super(19);
        this.source = GoldenMasterSource.RECORDED;
        this.ignoredAttributes = GloballyIgnoredAttributes.getInstance().getIgnoredAttributesList();
    }

    public ReplayResult(SuiteReplayResult newSuite) {
        this(GoldenMasterSource.RECORDED, newSuite);
    }

    public ReplayResult(GoldenMasterSource source, SuiteReplayResult newSuite) {
        super(19);
        this.source = source;
        this.ignoredAttributes = GloballyIgnoredAttributes.getInstance().getIgnoredAttributesList();
        this.suiteReplayResults.add(newSuite);
    }

    public void addSuite(SuiteReplayResult newReplayResult) {
        this.suiteReplayResults.add(newReplayResult);
    }

    public List<SuiteReplayResult> getSuiteReplayResults() {
        return Collections.unmodifiableList(this.suiteReplayResults);
    }

    public boolean containsChanges() {
        for (SuiteReplayResult suiteReplayResult : this.suiteReplayResults) {
            if (suiteReplayResult.getDifferencesCount() <= 0) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "ReplayResult(Tests: " + this.getNumberOfTests() + ", Actions: " + this.getNumberOfActions() + ", Checked Elements: " + this.getCheckedUiElementsCount() + ", Differences: " + this.getDifferencesCount() + ", Errors: " + this.getErrorsCount() + ")";
    }

    public int getNumberOfTests() {
        int testCount = 0;
        for (SuiteReplayResult suiteReplayResult : this.suiteReplayResults) {
            testCount += suiteReplayResult.getTestReplayResults().size();
        }
        return testCount;
    }

    public int getNumberOfActions() {
        int actionsCount = 0;
        for (SuiteReplayResult suiteReplayResult : this.suiteReplayResults) {
            actionsCount += suiteReplayResult.getNumberOfActions();
        }
        return actionsCount;
    }

    public long getDuration() {
        long duration = 0L;
        for (SuiteReplayResult suiteReplayResult : this.suiteReplayResults) {
            duration += suiteReplayResult.getDuration();
        }
        return duration;
    }

    public int getCheckedUiElementsCount() {
        int uiElementsCount = 0;
        for (SuiteReplayResult suiteReplayResult : this.suiteReplayResults) {
            uiElementsCount += suiteReplayResult.getCheckedUiElementsCount();
        }
        return uiElementsCount;
    }

    public int getDifferencesCount() {
        int differences = 0;
        for (SuiteReplayResult suiteReplayResult : this.suiteReplayResults) {
            differences += suiteReplayResult.getDifferencesCount();
        }
        return differences;
    }

    public int getErrorsCount() {
        int errors = 0;
        for (SuiteReplayResult suiteReplayResult : this.suiteReplayResults) {
            errors += suiteReplayResult.getErrorsCount();
        }
        return errors;
    }

    public String getExecSuiteSutVersion() {
        HashSet<String> versions = new HashSet<String>();
        for (SuiteReplayResult suiteReplayResult : this.suiteReplayResults) {
            versions.add(suiteReplayResult.getExecSuiteSutVersion());
        }
        if (versions.size() == 1) {
            return versions.toArray()[0].toString();
        }
        return ((Object)versions).toString();
    }

    public String getReplaySutVersion() {
        HashSet<String> versions = new HashSet<String>();
        for (SuiteReplayResult suiteReplayResult : this.suiteReplayResults) {
            versions.add(suiteReplayResult.getReplaySutVersion());
        }
        if (versions.size() == 1) {
            return versions.toArray()[0].toString();
        }
        return ((Object)versions).toString();
    }

    public boolean isEmpty() {
        return this.getNumberOfTestsWithChanges() == 0;
    }

    public int getNumberOfTestsWithChanges() {
        int result = 0;
        for (SuiteReplayResult suiteReplayResult : this.suiteReplayResults) {
            result += suiteReplayResult.getNumberOfTestsWithChanges();
        }
        return result;
    }

    public GoldenMasterSource getGoldenMasterSource() {
        return this.source;
    }
}

