/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.report;

import de.retest.recheck.persistence.xml.util.XmlUtil;
import de.retest.recheck.report.ActionReplayResult;
import de.retest.recheck.report.TestReplayResult;
import de.retest.recheck.suite.ExecutableSuite;
import de.retest.recheck.ui.descriptors.GroundState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="suite")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SuiteReplayResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SuiteReplayResult.class);
    @XmlAttribute
    private final String name;
    @XmlAttribute
    private final String suiteUuid;
    @XmlAttribute
    private final int suiteNr;
    @XmlElement(name="test")
    private List<TestReplayResult> testReplayResults = new ArrayList<TestReplayResult>();
    @XmlElement
    private long suiteDuration;
    @XmlElement
    private final GroundState execSuiteSutVersion;
    @XmlElement
    private final GroundState replaySutVersion;

    private SuiteReplayResult() {
        this.suiteNr = 0;
        this.name = null;
        this.execSuiteSutVersion = null;
        this.replaySutVersion = null;
        this.suiteUuid = null;
    }

    public SuiteReplayResult(ExecutableSuite suite, int suiteNr, GroundState replaySutVersion) {
        String string = this.name = suite.getName() == null ? "Suite no. " + suiteNr : XmlUtil.clean(suite.getName());
        if (suite.getName() == null) {
            logger.info("No suite name given, using {}.", (Object)this.name);
        }
        this.suiteNr = suiteNr;
        this.testReplayResults = new ArrayList<TestReplayResult>();
        this.execSuiteSutVersion = suite.getGroundState();
        this.suiteUuid = suite.getUuid();
        this.replaySutVersion = replaySutVersion;
    }

    public void addTest(TestReplayResult newReplayResult) {
        this.suiteDuration += newReplayResult.getDuration();
        this.testReplayResults.add(newReplayResult);
    }

    public String getSuiteName() {
        return this.name;
    }

    public long getDuration() {
        return this.suiteDuration;
    }

    public String getExecSuiteSutVersion() {
        if (this.execSuiteSutVersion == null) {
            return "unspecified SUT version";
        }
        return this.execSuiteSutVersion.getSutVersion();
    }

    public String getReplaySutVersion() {
        if (this.replaySutVersion == null) {
            return "unspecified SUT version";
        }
        return this.replaySutVersion.getSutVersion();
    }

    public List<TestReplayResult> getTestReplayResults() {
        return Collections.unmodifiableList(this.testReplayResults);
    }

    public int getNumberOfActions() {
        int actionCount = 0;
        for (TestReplayResult testReplayResult : this.testReplayResults) {
            actionCount += testReplayResult.getActionReplayResults().size();
        }
        return actionCount;
    }

    public int getDifferencesCount() {
        int diffsCount = 0;
        for (TestReplayResult testReplayResult : this.testReplayResults) {
            for (ActionReplayResult actionReplayResult : testReplayResult.getActionReplayResults()) {
                diffsCount += actionReplayResult.getAllElementDifferences().size();
            }
        }
        return diffsCount;
    }

    public int getErrorsCount() {
        int errorsCount = 0;
        for (TestReplayResult testReplayResult : this.testReplayResults) {
            for (ActionReplayResult actionReplayResult : testReplayResult.getActionReplayResults()) {
                if (actionReplayResult.getThrowableWrapper() == null && actionReplayResult.getTargetNotFoundWrapper() == null) continue;
                ++errorsCount;
            }
        }
        return errorsCount;
    }

    public int getCheckedUiElementsCount() {
        int uiElementsCount = 0;
        for (TestReplayResult testReplayResult : this.testReplayResults) {
            uiElementsCount += testReplayResult.getCheckedUiElementsCount();
        }
        return uiElementsCount;
    }

    public String toString() {
        return "SuiteReplayResult('" + this.getSuiteName() + "', Actions: " + this.getNumberOfActions() + ", Checked Elements: " + this.getCheckedUiElementsCount() + ", Differences: " + this.getDifferencesCount() + ", Errors: " + this.getErrorsCount() + ")";
    }

    public String getSuiteUuid() {
        return this.suiteUuid;
    }

    public boolean isEmpty() {
        return this.getNumberOfTestsWithChanges() != 0;
    }

    public int getNumberOfTestsWithChanges() {
        int result = 0;
        for (TestReplayResult testReplayResult : this.testReplayResults) {
            if (testReplayResult.isEmpty()) continue;
            ++result;
        }
        return result;
    }
}

