/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.report;

import de.retest.recheck.NoRecheckFileActionReplayResult;
import de.retest.recheck.ignore.ShouldIgnore;
import de.retest.recheck.persistence.xml.util.XmlUtil;
import de.retest.recheck.report.ActionReplayResult;
import de.retest.recheck.ui.diff.LeafDifference;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="test")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TestReplayResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(TestReplayResult.class);
    @XmlAttribute
    private final String name;
    @XmlAttribute
    private final int testNr;
    @XmlElement(name="action")
    private List<ActionReplayResult> actionReplayResults;
    @XmlElement
    private long testDuration;

    private TestReplayResult() {
        this.testNr = 0;
        this.name = null;
    }

    public TestReplayResult(String testName, int testNr) {
        String string = this.name = testName == null ? "Test no. " + testNr : XmlUtil.clean(testName);
        if (testName == null) {
            logger.info("No test name given, using {}.", (Object)this.name);
        }
        this.testNr = testNr;
        this.actionReplayResults = new ArrayList<ActionReplayResult>();
    }

    public long getDuration() {
        return this.testDuration;
    }

    public void addAction(ActionReplayResult newReplayResult) {
        this.testDuration += newReplayResult.getDuration();
        this.actionReplayResults.add(newReplayResult);
    }

    public String getName() {
        return this.name;
    }

    public List<ActionReplayResult> getActionReplayResults() {
        return Collections.unmodifiableList(this.actionReplayResults);
    }

    public int getCheckedUiElementsCount() {
        int uiElementsCount = 0;
        for (ActionReplayResult actionReplayResult : this.actionReplayResults) {
            uiElementsCount += actionReplayResult.getCheckedUiElementsCount();
        }
        return uiElementsCount;
    }

    public Set<LeafDifference> getDifferences(ShouldIgnore ignore) {
        HashSet<LeafDifference> diffs = new HashSet<LeafDifference>();
        for (ActionReplayResult actionReplayResult : this.actionReplayResults) {
            diffs.addAll(actionReplayResult.getDifferences(ignore));
        }
        return diffs;
    }

    public int getDifferencesCount() {
        int differences = 0;
        for (ActionReplayResult actionReplayResult : this.actionReplayResults) {
            differences += actionReplayResult.getAllElementDifferences().size();
        }
        return differences;
    }

    public boolean hasNoRecheckFiles() {
        for (ActionReplayResult result : this.actionReplayResults) {
            if (result instanceof NoRecheckFileActionReplayResult) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "TestReplayResult('" + this.getName() + "', Actions: " + this.getActionReplayResults().size() + ", Checked Elements: " + this.getCheckedUiElementsCount() + ", Differences: " + this.getDifferencesCount() + ")";
    }

    public boolean isEmpty() {
        return this.actionReplayResults.isEmpty();
    }
}

