/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.report.action;

import de.retest.recheck.ui.actions.Action;
import de.retest.recheck.ui.descriptors.Element;

public class ActionReplayData {
    private final String description;
    private final Element element;
    private final String stateFilePath;

    private ActionReplayData(String description, Element element, String stateFilePath) {
        this.description = description;
        this.element = element;
        this.stateFilePath = stateFilePath;
    }

    public static ActionReplayData of(Action action) {
        if (action != null) {
            return ActionReplayData.withTarget(action.toString(), action.getTargetElement());
        }
        return ActionReplayData.ofSutStart();
    }

    public static ActionReplayData ofSutStart() {
        return ActionReplayData.withoutTarget("Start Sut");
    }

    public static ActionReplayData empty() {
        return new ActionReplayData(null, null, null);
    }

    public static ActionReplayData withTarget(String description, Element element) {
        return ActionReplayData.withTarget(description, element, null);
    }

    public static ActionReplayData withTarget(String description, Element element, String stateFilePath) {
        return new ActionReplayData(description, element, stateFilePath);
    }

    public static ActionReplayData withoutTarget(String description) {
        return ActionReplayData.withoutTarget(description, null);
    }

    public static ActionReplayData withoutTarget(String description, String stateFilePath) {
        return new ActionReplayData(description, null, stateFilePath);
    }

    public String getDescription() {
        return this.description;
    }

    public Element getElement() {
        return this.element;
    }

    public String getStateFilePath() {
        return this.stateFilePath;
    }
}

