/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.report.action;

import de.retest.recheck.ui.actions.ExceptionWrapper;
import de.retest.recheck.ui.actions.TargetNotFoundException;
import de.retest.recheck.ui.actions.TargetNotFoundWrapper;

public class ErrorHolder {
    private final ExceptionWrapper exceptionWrapper;
    private final TargetNotFoundWrapper targetNotFoundWrapper;

    private ErrorHolder(ExceptionWrapper exceptionWrapper, TargetNotFoundWrapper targetNotFoundWrapper) {
        this.exceptionWrapper = exceptionWrapper;
        this.targetNotFoundWrapper = targetNotFoundWrapper;
    }

    public static ErrorHolder empty() {
        return ErrorHolder.of(ErrorHolder.wrapError(null), ErrorHolder.wrapTargetNotFound(null));
    }

    public static ErrorHolder of(Throwable exception) {
        return ErrorHolder.of(ErrorHolder.wrapError(exception), ErrorHolder.wrapTargetNotFound(null));
    }

    public static ErrorHolder of(TargetNotFoundException tnfe) {
        return ErrorHolder.of(ErrorHolder.wrapError(null), ErrorHolder.wrapTargetNotFound(tnfe));
    }

    public static ErrorHolder of(Throwable exception, TargetNotFoundException tnfe) {
        return ErrorHolder.of(ErrorHolder.wrapError(exception), ErrorHolder.wrapTargetNotFound(tnfe));
    }

    public static ErrorHolder of(ExceptionWrapper exception, TargetNotFoundException tnfe) {
        return ErrorHolder.of(exception, ErrorHolder.wrapTargetNotFound(tnfe));
    }

    public static ErrorHolder of(Throwable exception, TargetNotFoundWrapper tnfe) {
        return ErrorHolder.of(ErrorHolder.wrapError(exception), tnfe);
    }

    public static ErrorHolder of(ExceptionWrapper exception, TargetNotFoundWrapper tnfe) {
        return new ErrorHolder(exception, tnfe);
    }

    private static ExceptionWrapper wrapError(Throwable exception) {
        return exception != null ? new ExceptionWrapper(exception) : null;
    }

    private static TargetNotFoundWrapper wrapTargetNotFound(TargetNotFoundException targetNotFound) {
        return targetNotFound != null ? new TargetNotFoundWrapper(targetNotFound) : null;
    }

    public boolean hasThrowable() {
        return this.exceptionWrapper != null;
    }

    public Throwable getThrowable() {
        return this.exceptionWrapper != null ? this.exceptionWrapper.getThrowable() : null;
    }

    public ExceptionWrapper getThrowableWrapper() {
        return this.exceptionWrapper;
    }

    public boolean hasTargetNotFound() {
        return this.targetNotFoundWrapper != null;
    }

    public Throwable getTargetNotFoundException() {
        return this.targetNotFoundWrapper != null ? this.targetNotFoundWrapper.getTargetNotFoundException() : null;
    }

    public TargetNotFoundWrapper getTargetNotFoundWrapper() {
        return this.targetNotFoundWrapper;
    }

    public boolean hasError() {
        return this.exceptionWrapper != null || this.targetNotFoundWrapper != null;
    }

    public String toString() {
        if (this.hasThrowable()) {
            return this.exceptionWrapper.toString();
        }
        if (this.hasTargetNotFound()) {
            return this.targetNotFoundWrapper.toString();
        }
        return "no exception";
    }
}

