/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review;

import de.retest.recheck.ignore.ShouldIgnore;
import de.retest.recheck.review.GlobalChangeSetApplier;
import de.retest.recheck.review.GlobalIgnoreApplier;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.ui.diff.AttributesDifference;
import de.retest.recheck.ui.diff.Difference;
import de.retest.recheck.ui.diff.ElementDifference;
import de.retest.recheck.ui.diff.IdentifyingAttributesDifference;
import de.retest.recheck.ui.diff.InsertedDeletedElementDifference;
import de.retest.recheck.ui.review.ActionChangeSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AcceptableElementDifference {
    private static final ShouldIgnore SHOULD_IGNORE_NOTHING = null;
    private final ElementDifference elementDifference;
    private final List<AttributeDifference> identifyingAttributesAttributesDifferences;
    private final List<AttributeDifference> attributeDifferences;
    private final ActionChangeSet acceptedChanges;
    private final GlobalChangeSetApplier globalChangeApplier;
    private final GlobalIgnoreApplier globalIgnoreApplier;

    public AcceptableElementDifference(ElementDifference elementDifference, ActionChangeSet acceptedChanges, GlobalChangeSetApplier globalChangeApplier, GlobalIgnoreApplier globalIgnoreApplier) {
        this.elementDifference = elementDifference;
        this.globalChangeApplier = globalChangeApplier;
        this.globalIgnoreApplier = globalIgnoreApplier;
        this.acceptedChanges = acceptedChanges;
        ArrayList<AttributeDifference> prepareIdentifyingAttributesDifferences = new ArrayList<AttributeDifference>();
        ArrayList<AttributeDifference> prepareAttributeDifferences = new ArrayList<AttributeDifference>();
        for (Difference difference : elementDifference.getImmediateDifferences()) {
            if (difference instanceof IdentifyingAttributesDifference) {
                prepareIdentifyingAttributesDifferences.addAll(((IdentifyingAttributesDifference)difference).getAttributeDifferences());
            }
            if (!(difference instanceof AttributesDifference)) continue;
            prepareAttributeDifferences.addAll(((AttributesDifference)difference).getDifferences());
        }
        this.identifyingAttributesAttributesDifferences = Collections.unmodifiableList(prepareIdentifyingAttributesDifferences);
        this.attributeDifferences = Collections.unmodifiableList(prepareAttributeDifferences);
    }

    public ElementDifference getElementDifference() {
        return this.elementDifference;
    }

    public List<AttributeDifference> getAttributeDifferences() {
        ArrayList<AttributeDifference> result = new ArrayList<AttributeDifference>();
        result.addAll(this.identifyingAttributesAttributesDifferences);
        result.addAll(this.attributeDifferences);
        return result;
    }

    public boolean isAccepted() {
        if (this.globalIgnoreApplier.shouldIgnoreElement(this.getElementDifference().getElement())) {
            return true;
        }
        boolean result = true;
        for (AttributeDifference attributeDifference : this.getAttributeDifferences()) {
            result &= this.isAccepted(attributeDifference) || this.isIgnored(attributeDifference);
        }
        return result;
    }

    public boolean isAccepted(AttributeDifference attributeDifference) {
        if (this.isIdentAttribute(attributeDifference)) {
            return this.acceptedChanges.getIdentAttributeChanges().contains(this.elementDifference.getIdentifyingAttributes(), attributeDifference);
        }
        return this.acceptedChanges.getAttributesChanges().contains(this.elementDifference.getIdentifyingAttributes(), attributeDifference);
    }

    public void accept(AttributeDifference attributeDifference) {
        IdentifyingAttributes identifyingAttributes = this.elementDifference.getIdentifyingAttributes();
        assert (this.elementDifference.getAttributeDifferences(SHOULD_IGNORE_NOTHING).contains(attributeDifference));
        if (this.elementDifference.isInsertion()) {
            this.globalChangeApplier.addChangeSetForAllEqualInsertedChanges(((InsertedDeletedElementDifference)this.elementDifference.getIdentifyingAttributesDifference()).getActual());
        } else if (this.elementDifference.isDeletion()) {
            this.globalChangeApplier.addChangeSetForAllEqualDeletedChanges(identifyingAttributes);
        } else if (this.isIdentAttribute(attributeDifference)) {
            this.globalChangeApplier.addChangeSetForAllEqualIdentAttributeChanges(identifyingAttributes, attributeDifference);
        } else {
            this.globalChangeApplier.createChangeSetForAllEqualAttributesChanges(identifyingAttributes, attributeDifference);
        }
    }

    public void unaccept(AttributeDifference attributeDifference) {
        IdentifyingAttributes identifyingAttributes = this.elementDifference.getIdentifyingAttributes();
        if (this.elementDifference.isInsertion()) {
            this.globalChangeApplier.removeChangeSetForAllEqualInsertedChanges(((InsertedDeletedElementDifference)this.elementDifference.getIdentifyingAttributesDifference()).getActual());
        } else if (this.elementDifference.isDeletion()) {
            this.globalChangeApplier.removeChangeSetForAllEqualDeletedChanges(identifyingAttributes);
        } else if (this.isIdentAttribute(attributeDifference)) {
            this.globalChangeApplier.removeChangeSetForAllEqualIdentAttributeChanges(identifyingAttributes, attributeDifference);
        } else {
            this.globalChangeApplier.removeChangeSetForAllEqualAttributesChanges(identifyingAttributes, attributeDifference);
        }
    }

    private boolean isIdentAttribute(AttributeDifference attributeDifference) {
        boolean identifyingAttributesAttrib = this.identifyingAttributesAttributesDifferences.contains(attributeDifference);
        boolean attributesAttrib = this.attributeDifferences.contains(attributeDifference);
        assert (identifyingAttributesAttrib != attributesAttrib) : "attribute must exist in exact one of both lists";
        return identifyingAttributesAttrib;
    }

    public boolean isIgnored(AttributeDifference difference) {
        return this.globalIgnoreApplier.shouldIgnoreAttributeDifference(this.getElementDifference().getElement(), difference);
    }

    public void ignore(AttributeDifference attributeDifference) {
        this.globalIgnoreApplier.ignoreAttribute(this.getElementDifference().getElement(), attributeDifference);
    }

    public void unignore(AttributeDifference attributeDifference) {
        this.globalIgnoreApplier.unignoreAttribute(this.getElementDifference().getElement(), attributeDifference);
    }
}

