/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import de.retest.recheck.ignore.ShouldIgnore;
import de.retest.recheck.report.ActionReplayResult;
import de.retest.recheck.report.ReplayResult;
import de.retest.recheck.report.SuiteReplayResult;
import de.retest.recheck.report.TestReplayResult;
import de.retest.recheck.review.counter.Counter;
import de.retest.recheck.review.counter.NopCounter;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.ui.diff.ElementDifference;
import de.retest.recheck.ui.diff.InsertedDeletedElementDifference;
import de.retest.recheck.ui.review.ActionChangeSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class GlobalChangeSetApplier {
    private static final ShouldIgnore SHOULD_IGNORE_NOTHING = null;
    private final Counter counter;
    private final Multimap<ImmutablePair<IdentifyingAttributes, AttributeDifference>, ActionReplayResult> attributeDiffsLookupMap;
    private final Multimap<Element, ActionReplayResult> insertedDiffsLookupMap;
    private final Multimap<IdentifyingAttributes, ActionReplayResult> deletedDiffsLookupMap;
    private final Map<ActionReplayResult, ActionChangeSet> actionChangeSetLookupMap;

    private GlobalChangeSetApplier(ReplayResult replayResult, Counter counter) {
        this.counter = counter;
        this.attributeDiffsLookupMap = ArrayListMultimap.create();
        this.insertedDiffsLookupMap = ArrayListMultimap.create();
        this.deletedDiffsLookupMap = ArrayListMultimap.create();
        this.actionChangeSetLookupMap = new HashMap<ActionReplayResult, ActionChangeSet>();
        this.fillReplayResultLookupMaps(replayResult);
    }

    public static GlobalChangeSetApplier create(ReplayResult replayResult) {
        return GlobalChangeSetApplier.create(replayResult, NopCounter.getInstance());
    }

    public static GlobalChangeSetApplier create(ReplayResult replayResult, Counter counter) {
        return new GlobalChangeSetApplier(replayResult, counter);
    }

    private void fillReplayResultLookupMaps(ReplayResult replayResult) {
        for (SuiteReplayResult suiteReplayResult : replayResult.getSuiteReplayResults()) {
            for (TestReplayResult testReplayResult : suiteReplayResult.getTestReplayResults()) {
                for (ActionReplayResult actionReplayResult : testReplayResult.getActionReplayResults()) {
                    for (ElementDifference componentDiff : actionReplayResult.getAllElementDifferences()) {
                        if (componentDiff.isInsertionOrDeletion()) {
                            this.fillInsertedDeletedDifferencesLookupMaps(actionReplayResult, componentDiff);
                            continue;
                        }
                        this.fillAttributeDifferencesLookupMap(actionReplayResult, componentDiff);
                    }
                }
            }
        }
    }

    private void fillInsertedDeletedDifferencesLookupMaps(ActionReplayResult actionReplayResult, ElementDifference componentDiff) {
        InsertedDeletedElementDifference insertedDeletedComponentDiff = (InsertedDeletedElementDifference)componentDiff.getIdentifyingAttributesDifference();
        if (insertedDeletedComponentDiff.isInserted()) {
            this.insertedDiffsLookupMap.put((Object)insertedDeletedComponentDiff.getActual(), (Object)actionReplayResult);
        } else {
            this.deletedDiffsLookupMap.put((Object)componentDiff.getIdentifyingAttributes(), (Object)actionReplayResult);
        }
    }

    private void fillAttributeDifferencesLookupMap(ActionReplayResult actionReplayResult, ElementDifference componentDiff) {
        IdentifyingAttributes identifyingAttributes = componentDiff.getIdentifyingAttributes();
        for (AttributeDifference attributeDifference : componentDiff.getAttributeDifferences(SHOULD_IGNORE_NOTHING)) {
            this.attributeDiffsLookupMap.put((Object)ImmutablePair.of((Object)identifyingAttributes, (Object)attributeDifference), (Object)actionReplayResult);
        }
    }

    private Collection<ActionReplayResult> findAllActionResultsWithEqualDifferences(IdentifyingAttributes identifyingAttributes, AttributeDifference attributeDifference) {
        return this.attributeDiffsLookupMap.get((Object)ImmutablePair.of((Object)identifyingAttributes, (Object)attributeDifference));
    }

    private ActionChangeSet findCorrespondingActionChangeSet(ActionReplayResult actionReplayResult) {
        ActionChangeSet actionChangeSet = this.actionChangeSetLookupMap.get(actionReplayResult);
        assert (actionChangeSet != null) : "Error, introduce() wasn't called for this actionReplayResult!";
        return actionChangeSet;
    }

    public void introduce(ActionReplayResult actionReplayResult, ActionChangeSet actionChangeSet) {
        this.actionChangeSetLookupMap.put(actionReplayResult, actionChangeSet);
    }

    public void addChangeSetForAllEqualIdentAttributeChanges(IdentifyingAttributes identifyingAttributes, AttributeDifference attributeDifference) {
        Collection<ActionReplayResult> actionResultsWithDiffs = this.findAllActionResultsWithEqualDifferences(identifyingAttributes, attributeDifference);
        assert (!actionResultsWithDiffs.isEmpty()) : "Should have been added during load and thus not be empty!";
        for (ActionReplayResult actionReplayResult : actionResultsWithDiffs) {
            ActionChangeSet correspondingActionChangeSet = this.findCorrespondingActionChangeSet(actionReplayResult);
            assert (correspondingActionChangeSet != null) : "Should have been added during load and thus not be empty!";
            correspondingActionChangeSet.getIdentAttributeChanges().add(identifyingAttributes, attributeDifference);
        }
        this.counter.add();
    }

    public void createChangeSetForAllEqualAttributesChanges(IdentifyingAttributes identifyingAttributes, AttributeDifference attributeDifference) {
        for (ActionReplayResult actionReplayResult : this.findAllActionResultsWithEqualDifferences(identifyingAttributes, attributeDifference)) {
            this.findCorrespondingActionChangeSet(actionReplayResult).getAttributesChanges().add(identifyingAttributes, attributeDifference);
        }
        this.counter.add();
    }

    public void removeChangeSetForAllEqualIdentAttributeChanges(IdentifyingAttributes identifyingAttributes, AttributeDifference attributeDifference) {
        for (ActionReplayResult actionReplayResult : this.findAllActionResultsWithEqualDifferences(identifyingAttributes, attributeDifference)) {
            this.findCorrespondingActionChangeSet(actionReplayResult).getIdentAttributeChanges().remove(identifyingAttributes, attributeDifference);
        }
        this.counter.remove();
    }

    public void removeChangeSetForAllEqualAttributesChanges(IdentifyingAttributes identifyingAttributes, AttributeDifference attributeDifference) {
        for (ActionReplayResult actionReplayResult : this.findAllActionResultsWithEqualDifferences(identifyingAttributes, attributeDifference)) {
            this.findCorrespondingActionChangeSet(actionReplayResult).getAttributesChanges().remove(identifyingAttributes, attributeDifference);
        }
        this.counter.remove();
    }

    public void addChangeSetForAllEqualInsertedChanges(Element inserted) {
        for (ActionReplayResult replayResult : this.insertedDiffsLookupMap.get((Object)inserted)) {
            this.findCorrespondingActionChangeSet(replayResult).addInsertChange(inserted);
        }
        this.counter.add();
    }

    public void addChangeSetForAllEqualDeletedChanges(IdentifyingAttributes deleted) {
        for (ActionReplayResult replayResult : this.deletedDiffsLookupMap.get((Object)deleted)) {
            this.findCorrespondingActionChangeSet(replayResult).addDeletedChange(deleted);
        }
        this.counter.add();
    }

    public void removeChangeSetForAllEqualInsertedChanges(Element inserted) {
        for (ActionReplayResult replayResult : this.insertedDiffsLookupMap.get((Object)inserted)) {
            this.findCorrespondingActionChangeSet(replayResult).removeInsertChange(inserted);
        }
        this.counter.remove();
    }

    public void removeChangeSetForAllEqualDeletedChanges(IdentifyingAttributes deleted) {
        for (ActionReplayResult replayResult : this.deletedDiffsLookupMap.get((Object)deleted)) {
            this.findCorrespondingActionChangeSet(replayResult).removeDeletedChange(deleted);
        }
        this.counter.remove();
    }
}

