/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review;

import de.retest.recheck.ignore.ShouldIgnore;
import de.retest.recheck.review.counter.Counter;
import de.retest.recheck.review.ignore.ElementAttributeShouldIgnore;
import de.retest.recheck.review.ignore.ElementShouldIgnore;
import de.retest.recheck.review.ignore.matcher.ElementXPathMatcher;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.diff.AttributeDifference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

public class GlobalIgnoreApplier
implements ShouldIgnore {
    private final Counter counter;
    private final List<ShouldIgnore> ignored = new ArrayList<ShouldIgnore>();

    private GlobalIgnoreApplier(Counter counter, List<ShouldIgnore> ignored) {
        this.counter = counter;
        this.ignored.addAll(ignored);
    }

    public static GlobalIgnoreApplier create(Counter counter) {
        return new GlobalIgnoreApplier(counter, Collections.emptyList());
    }

    public static GlobalIgnoreApplier create(Counter counter, PersistableGlobalIgnoreApplier applier) {
        return new GlobalIgnoreApplier(counter, applier.getIgnores());
    }

    @Override
    public boolean shouldIgnoreAttributeDifference(Element element, AttributeDifference difference) {
        return this.any(ignore -> ignore.shouldIgnoreAttributeDifference(element, difference));
    }

    public void ignoreAttribute(Element element, AttributeDifference difference) {
        this.add(new ElementAttributeShouldIgnore(new ElementXPathMatcher(element), difference.getKey()));
    }

    public void unignoreAttribute(Element element, AttributeDifference difference) {
        this.remove(ignore -> ignore.shouldIgnoreAttributeDifference(element, difference));
    }

    @Override
    public boolean shouldIgnoreElement(Element element) {
        return this.any(ignore -> ignore.shouldIgnoreElement(element));
    }

    public void ignoreElement(Element element) {
        this.add(new ElementShouldIgnore(new ElementXPathMatcher(element)));
    }

    public void unignoreElement(Element element) {
        this.remove(ignore -> ignore.shouldIgnoreElement(element));
    }

    public void add(ShouldIgnore ignore) {
        this.ignored.add(ignore);
        this.counter.add();
    }

    private void remove(Predicate<ShouldIgnore> filter) {
        this.ignored.removeIf(filter);
        this.counter.remove();
    }

    private boolean any(Predicate<ShouldIgnore> ignore) {
        return this.ignored.stream().anyMatch(ignore);
    }

    public PersistableGlobalIgnoreApplier persist() {
        return new PersistableGlobalIgnoreApplier(this.ignored);
    }

    public static class PersistableGlobalIgnoreApplier {
        private final List<ShouldIgnore> ignores;

        public PersistableGlobalIgnoreApplier(List<ShouldIgnore> ignores) {
            this.ignores = new ArrayList<ShouldIgnore>(ignores);
        }

        public List<ShouldIgnore> getIgnores() {
            return this.ignores;
        }
    }
}

