/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review.ignore;

import de.retest.recheck.ignore.ShouldIgnore;
import de.retest.recheck.review.ignore.io.RegexLoader;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.diff.AttributeDifference;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public class AttributeShouldIgnore
implements ShouldIgnore {
    private final String attribute;

    public AttributeShouldIgnore(String attribute) {
        this.attribute = attribute;
    }

    @Override
    public boolean shouldIgnoreElement(Element element) {
        return false;
    }

    @Override
    public boolean shouldIgnoreAttributeDifference(Element element, AttributeDifference attributeDifference) {
        return attributeDifference.getKey().matches(this.attribute);
    }

    public String toString() {
        return String.format("attribute=%s", this.attribute);
    }

    public static class AttributeShouldIgnoreLoader
    extends RegexLoader<AttributeShouldIgnore> {
        private static final String KEY = "attribute=";
        private static final String FORMAT = "attribute=%s";
        private static final Pattern REGEX = Pattern.compile("attribute=(.+)");

        public AttributeShouldIgnoreLoader() {
            super(REGEX);
        }

        @Override
        protected AttributeShouldIgnore load(MatchResult regex) {
            String attribute = regex.group(1);
            return new AttributeShouldIgnore(attribute);
        }
    }
}

