/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review.ignore;

import de.retest.recheck.ignore.ShouldIgnore;
import de.retest.recheck.review.ignore.io.Loader;
import de.retest.recheck.review.ignore.io.Loaders;
import de.retest.recheck.review.ignore.io.RegexLoader;
import de.retest.recheck.review.ignore.matcher.Matcher;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.diff.AttributeDifference;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public class ElementAttributeShouldIgnore
implements ShouldIgnore {
    private final Matcher<Element> matcher;
    private final String key;

    public ElementAttributeShouldIgnore(Matcher<Element> matcher, String key) {
        this.matcher = matcher;
        this.key = key;
    }

    @Override
    public boolean shouldIgnoreElement(Element element) {
        return false;
    }

    @Override
    public boolean shouldIgnoreAttributeDifference(Element element, AttributeDifference attributeDifference) {
        return this.matcher.test(element) && this.key.equals(attributeDifference.getKey());
    }

    public String toString() {
        return String.format("matcher: %s, attribute: %s", this.matcher.toString(), this.key);
    }

    public static class ElementAttributeShouldIgnoreLoader
    extends RegexLoader<ElementAttributeShouldIgnore> {
        private static final String MATCHER = "matcher: ";
        private static final String KEY = "attribute: ";
        private static final String FORMAT = "matcher: %s, attribute: %s";
        private static final Pattern REGEX = Pattern.compile("matcher: (.+), attribute: (.+)");

        public ElementAttributeShouldIgnoreLoader() {
            super(REGEX);
        }

        @Override
        protected ElementAttributeShouldIgnore load(MatchResult regex) {
            String matcher = regex.group(1);
            Loader loader = Loaders.get(matcher);
            String key = regex.group(2);
            return new ElementAttributeShouldIgnore((Matcher)loader.load(matcher), key);
        }
    }
}

