/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review.ignore;

import de.retest.recheck.ignore.ShouldIgnore;
import de.retest.recheck.review.ignore.io.Loader;
import de.retest.recheck.review.ignore.io.Loaders;
import de.retest.recheck.review.ignore.io.RegexLoader;
import de.retest.recheck.review.ignore.matcher.Matcher;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.diff.AttributeDifference;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public class ElementShouldIgnore
implements ShouldIgnore {
    private final Matcher<Element> matcher;

    public ElementShouldIgnore(Matcher<Element> matcher) {
        this.matcher = matcher;
    }

    @Override
    public boolean shouldIgnoreElement(Element element) {
        return this.matcher.test(element);
    }

    @Override
    public boolean shouldIgnoreAttributeDifference(Element element, AttributeDifference attributeDifference) {
        return false;
    }

    public String toString() {
        return String.format("matcher: %s", this.matcher.toString());
    }

    public static class ElementShouldIgnoreLoader
    extends RegexLoader<ElementShouldIgnore> {
        private static final String MATCHER = "matcher: ";
        private static final String FORMAT = "matcher: %s";
        private static final Pattern PREFIX = Pattern.compile("matcher: (.+)");

        public ElementShouldIgnoreLoader() {
            super(PREFIX);
        }

        @Override
        protected ElementShouldIgnore load(MatchResult regex) {
            String matcher = regex.group(1);
            Loader loader = Loaders.get(matcher);
            return new ElementShouldIgnore((Matcher)loader.load(matcher));
        }
    }
}

