/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review.ignore.io;

import de.retest.recheck.ignore.JSShouldIgnoreImpl;
import de.retest.recheck.review.ignore.AttributeShouldIgnore;
import de.retest.recheck.review.ignore.ElementAttributeShouldIgnore;
import de.retest.recheck.review.ignore.ElementShouldIgnore;
import de.retest.recheck.review.ignore.IgnoreCommentLoader;
import de.retest.recheck.review.ignore.JSShouldIgnoreLoader;
import de.retest.recheck.review.ignore.io.Loader;
import de.retest.recheck.review.ignore.matcher.ElementIdMatcher;
import de.retest.recheck.review.ignore.matcher.ElementRetestIdMatcher;
import de.retest.recheck.review.ignore.matcher.ElementXPathMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class Loaders {
    private static final List<Pair<Class<?>, Loader<?>>> registeredLoaders = Loaders.registerLoaders();

    private Loaders() {
    }

    private static List<Pair<Class<?>, Loader<?>>> registerLoaders() {
        ArrayList pairs = new ArrayList();
        pairs.add(Pair.of(ElementIdMatcher.class, (Object)new ElementIdMatcher.ElementIdMatcherLoader()));
        pairs.add(Pair.of(ElementRetestIdMatcher.class, (Object)new ElementRetestIdMatcher.ElementRetestIdMatcherLoader()));
        pairs.add(Pair.of(ElementXPathMatcher.class, (Object)new ElementXPathMatcher.ElementXpathMatcherLoader()));
        pairs.add(Pair.of(ElementAttributeShouldIgnore.class, (Object)new ElementAttributeShouldIgnore.ElementAttributeShouldIgnoreLoader()));
        pairs.add(Pair.of(AttributeShouldIgnore.class, (Object)new AttributeShouldIgnore.AttributeShouldIgnoreLoader()));
        pairs.add(Pair.of(ElementShouldIgnore.class, (Object)new ElementShouldIgnore.ElementShouldIgnoreLoader()));
        pairs.add(Pair.of(IgnoreCommentLoader.ShouldIgnoreComment.class, (Object)new IgnoreCommentLoader()));
        pairs.add(Pair.of(JSShouldIgnoreImpl.class, (Object)new JSShouldIgnoreLoader()));
        return pairs;
    }

    public static <T> Loader<T> get(Class<? extends T> clazz) {
        return registeredLoaders.stream().filter(pair -> clazz.isAssignableFrom((Class)pair.getLeft())).findFirst().map(Pair::getRight).orElseThrow(() -> new UnsupportedOperationException("No loader registered for " + clazz));
    }

    public static <T> Loader<T> get(String line) {
        return registeredLoaders.stream().filter(pair -> ((Loader)pair.getRight()).canLoad(line)).findFirst().map(Pair::getRight).orElseThrow(() -> new UnsupportedOperationException("No loader registered for " + line));
    }

    public static Stream<String> save(Stream<?> objects) {
        return objects.map(Loaders::save);
    }

    private static <T> String save(T object) {
        Loader<?> loader = Loaders.get(object.getClass());
        return loader.save(object);
    }

    public static Stream<?> load(Stream<String> lines) {
        return lines.map(String::trim).filter(StringUtils::isNotEmpty).map(Loaders::load);
    }

    private static <T> T load(String line) {
        return (T)registeredLoaders.stream().map(Pair::getRight).filter(loader -> loader.canLoad(line)).findFirst().map(loader -> loader.load(line)).orElseThrow(() -> new IllegalArgumentException("Line '" + line + "' has no loader."));
    }
}

