/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.review.ignore.matcher;

import de.retest.recheck.review.ignore.io.RegexLoader;
import de.retest.recheck.review.ignore.matcher.Matcher;
import de.retest.recheck.ui.descriptors.Element;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public class ElementXPathMatcher
implements Matcher<Element> {
    private final String xpath;

    public ElementXPathMatcher(Element element) {
        this(element.getIdentifyingAttributes().getPath());
    }

    private ElementXPathMatcher(String xpath) {
        this.xpath = xpath;
    }

    @Override
    public boolean test(Element element) {
        return element.getIdentifyingAttributes().getPath().startsWith(this.xpath);
    }

    public String toString() {
        return String.format("xpath=%s", this.xpath);
    }

    public static final class ElementXpathMatcherLoader
    extends RegexLoader<ElementXPathMatcher> {
        private static final String XPATH = "xpath=";
        private static final String FORMAT = "xpath=%s";
        private static final Pattern REGEX = Pattern.compile("xpath=(.+)");

        public ElementXpathMatcherLoader() {
            super(REGEX);
        }

        @Override
        protected ElementXPathMatcher load(MatchResult matcher) {
            String xpath = matcher.group(1);
            return new ElementXPathMatcher(xpath);
        }
    }
}

