/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.suite.flow;

import de.retest.recheck.persistence.NoStateFileFoundException;
import de.retest.recheck.persistence.Persistence;
import de.retest.recheck.persistence.RecheckStateFileProvider;
import de.retest.recheck.persistence.RecheckStateFileProviderImpl;
import de.retest.recheck.ui.descriptors.SutState;
import de.retest.recheck.ui.review.ActionChangeSet;
import de.retest.recheck.ui.review.SuiteChangeSet;
import de.retest.recheck.ui.review.TestChangeSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplyChangesToStatesFlow {
    private static final Logger logger = LoggerFactory.getLogger(ApplyChangesToStatesFlow.class);
    private final RecheckStateFileProvider recheckStateFileProvider;

    public static List<String> apply(Persistence<SutState> persistence, SuiteChangeSet acceptedChanges) throws NoStateFileFoundException {
        return new ApplyChangesToStatesFlow(persistence).apply(acceptedChanges);
    }

    private ApplyChangesToStatesFlow(Persistence<SutState> persistence) {
        this.recheckStateFileProvider = new RecheckStateFileProviderImpl(persistence);
    }

    private List<String> apply(SuiteChangeSet acceptedChanges) throws NoStateFileFoundException {
        ArrayList<String> updatedFiles = new ArrayList<String>();
        for (TestChangeSet testChangeSet : acceptedChanges.getTestChangeSets()) {
            updatedFiles.addAll(this.apply(testChangeSet));
        }
        return updatedFiles;
    }

    private List<String> apply(TestChangeSet testChangeSet) throws NoStateFileFoundException {
        if (testChangeSet.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> updatedFiles = new ArrayList<String>();
        for (ActionChangeSet changeSet : testChangeSet.getActionChangeSets()) {
            updatedFiles.addAll(this.apply(changeSet));
        }
        if (testChangeSet.containsInitialStateChangeSet()) {
            ActionChangeSet changeSet = testChangeSet.getInitialStateChangeSet();
            updatedFiles.addAll(this.apply(changeSet));
        }
        return updatedFiles;
    }

    private List<String> apply(ActionChangeSet actionChangeSet) throws NoStateFileFoundException {
        if (actionChangeSet.isEmpty()) {
            return Collections.emptyList();
        }
        File file = this.recheckStateFileProvider.getRecheckStateFile(actionChangeSet.getStateFilePath());
        SutState oldState = this.recheckStateFileProvider.loadRecheckState(file);
        SutState newState = oldState.applyChanges(actionChangeSet);
        if (newState.equals(oldState)) {
            logger.debug("SutState {} did not change after applying changes, so not persisting it...", (Object)oldState);
            return Collections.emptyList();
        }
        this.recheckStateFileProvider.saveRecheckState(file, newState);
        return Collections.singletonList(actionChangeSet.getDescription());
    }
}

