/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui;

import de.retest.recheck.ui.DefaultValueFinder;
import de.retest.recheck.ui.TargetFinder;
import de.retest.recheck.ui.actions.Action;
import de.retest.recheck.ui.actions.ActionExecutionResult;
import de.retest.recheck.ui.actions.TargetNotFoundException;
import de.retest.recheck.ui.components.Component;
import de.retest.recheck.ui.components.RootContainer;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.descriptors.RootElement;
import de.retest.recheck.ui.image.Screenshot;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Environment<T>
implements DefaultValueFinder {
    private static final Logger logger = LoggerFactory.getLogger(Environment.class);
    protected boolean screenshots = true;

    public abstract void execute(Task var1);

    public abstract ActionExecutionResult execute(Action var1);

    public abstract List<RootContainer<T>> getTargetableWindows();

    public abstract void waitForStabilization();

    public abstract void reset();

    public abstract boolean hasSystemExited();

    public abstract Screenshot getScreenshot(T var1);

    public abstract Screenshot[] getWindowsScreenshots();

    public abstract Rectangle getOutlineInWindowCoordinates(T var1);

    public abstract List<Action> getAllActions();

    public List<RootElement> getTargetableRootElements() {
        if (this.hasSystemExited()) {
            return new ArrayList<RootElement>();
        }
        return this.getRootElements(this.getTargetableWindows());
    }

    public ImmutablePair<TargetNotFoundException, Component<T>> findTargetComponent(Element element) {
        return TargetFinder.findTargetComponent(element, this.getTargetableWindows(), this.getWindowsScreenshots());
    }

    public ImmutablePair<TargetNotFoundException, Component<T>> findTargetComponent(Action action) {
        return TargetFinder.findTargetComponent(action, this.getTargetableWindows(), this.getWindowsScreenshots());
    }

    protected ArrayList<RootElement> getRootElements(List<RootContainer<T>> windows) {
        if (this.hasSystemExited()) {
            return new ArrayList<RootElement>();
        }
        ArrayList<RootElement> result = new ArrayList<RootElement>();
        for (RootContainer<T> window : windows) {
            result.add(window.getRootElement());
        }
        return result;
    }

    public abstract void reloadWindows();

    public void disableScreenshots() {
        this.screenshots = false;
    }

    public void enableScreenshots() {
        this.screenshots = true;
    }

    public void handleReTestBug(String msg, Throwable exc) {
        logger.error("********************************************************************************");
        logger.error(msg, exc);
        logger.error("");
        logger.error("");
        logger.error("Congratulations, it appears you have found a bug in ReTest!");
        logger.error("Due to our constant effort to increase quality, this should be a rare event...");
        logger.error("");
        logger.error("And it is your chance! Your chance to improve ReTest. Your chance to give something back. Your chance to help us make this a better world.");
        logger.error("Since you discovered this bug, you probably know already more about it than anybody else (i.e. how to trigger it).");
        logger.error("So please, if you can, analyze and fix the bug you just found.");
        logger.error("Then go to https://github.com/retest/retest/wiki and find out how to contribute your fix.");
        logger.error("");
        logger.error("Thank you. People like you are the reason this software is free.");
        logger.error("********************************************************************************");
    }

    @Override
    public boolean isDefaultValue(IdentifyingAttributes comp, String s, Serializable attributesKey) {
        return false;
    }

    public abstract Object getExecutionTrace();

    public static interface Task {
        public void execute();
    }
}

