/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui;

import de.retest.recheck.persistence.StringInternerAdapter;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class PathElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    @XmlJavaTypeAdapter(value=StringInternerAdapter.class)
    private final String elementName;
    @XmlElement
    private final int suffix;

    public PathElement(String elementName, int suffix) {
        if (elementName == null) {
            throw new NullPointerException("Element name must not be null.");
        }
        this.elementName = elementName.trim();
        if (this.elementName.isEmpty()) {
            throw new IllegalArgumentException("Element name must not be empty.");
        }
        this.suffix = suffix;
    }

    public PathElement(String elementName) {
        this(elementName, 1);
    }

    public String getElementName() {
        return this.elementName;
    }

    public int getSuffix() {
        return this.suffix;
    }

    public String toString() {
        return this.elementName + "[" + this.suffix + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elementName == null ? 0 : this.elementName.hashCode());
        result = 31 * result + this.suffix;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathElement other = (PathElement)obj;
        return this.elementName.equals(other.elementName) && this.suffix == other.suffix;
    }

    public static PathElement fromString(String path) {
        if (!path.contains("[")) {
            return new PathElement(path);
        }
        return new PathElement(path.substring(0, path.indexOf(91)), Integer.parseInt(path.substring(path.indexOf(91) + 1, path.length() - 1)));
    }
}

