/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui;

import de.retest.recheck.ui.actions.Action;
import de.retest.recheck.ui.actions.TargetNotFoundException;
import de.retest.recheck.ui.components.Component;
import de.retest.recheck.ui.components.RootContainer;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.image.Screenshot;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetFinder<T> {
    private static final Logger logger = LoggerFactory.getLogger(TargetFinder.class);
    private final List<RootContainer<T>> targetableWindows;
    private final Screenshot[] windowsScreenshots;
    public static final double MATCH_THRESHOLD = 0.7;

    public static <T> ImmutablePair<TargetNotFoundException, Component<T>> findTargetComponent(Element element, List<RootContainer<T>> targetableWindows, Screenshot[] windowsScreenshots) {
        return super.findTargetComponent(null, element);
    }

    public static <T> ImmutablePair<TargetNotFoundException, Component<T>> findTargetComponent(Action action, List<RootContainer<T>> targetableWindows, Screenshot[] windowsScreenshots) {
        return super.findTargetComponent(action, action.getTargetElement());
    }

    private TargetFinder(List<RootContainer<T>> targetableWindows, Screenshot[] windowsScreenshots) {
        this.targetableWindows = targetableWindows;
        this.windowsScreenshots = windowsScreenshots;
    }

    private ImmutablePair<TargetNotFoundException, Component<T>> findTargetComponent(Action action, Element element) {
        double match;
        if (action != null && !action.getTargetElement().equals(element)) {
            throw new IllegalArgumentException("If an action is passed the element must be retrieved from Action#getTargetElement()");
        }
        IdentifyingAttributes identifyingAttributes = element.getIdentifyingAttributes();
        Component<T> bestMatch = this.getBestMatchForAllWindows(element);
        double d = match = bestMatch != null ? bestMatch.match(identifyingAttributes) : 0.0;
        if (match >= 0.7) {
            return new ImmutablePair(null, bestMatch);
        }
        if (this.bestMatchHasSameTypeAndText(identifyingAttributes, bestMatch)) {
            logger.error("Our threshold would reject this component, but it seems to be correct: {} - {}", (Object)bestMatch.getIdentifyingAttributes().toFullString(), (Object)identifyingAttributes.toFullString());
            return new ImmutablePair(null, bestMatch);
        }
        this.logError(identifyingAttributes);
        if (bestMatch != null) {
            String percentageOfBestMatch = String.format("%.2f", match * 100.0);
            logger.error("Best with {}% match is {}", (Object)percentageOfBestMatch, (Object)bestMatch.getIdentifyingAttributes().toFullString());
            String message = "Could not find component " + identifyingAttributes.toFullString() + " in " + this.targetableWindows.size() + " windows! Best with " + percentageOfBestMatch + "% match is " + bestMatch.getIdentifyingAttributes().toFullString();
            TargetNotFoundException tnfe = new TargetNotFoundException(action, bestMatch.getElement(), this.windowsScreenshots, message);
            return new ImmutablePair((Object)tnfe, null);
        }
        TargetNotFoundException tnfe = new TargetNotFoundException(action, null, this.windowsScreenshots, "Could not resolve component " + identifyingAttributes + "! No best match found!");
        return new ImmutablePair((Object)tnfe, null);
    }

    private boolean bestMatchHasSameTypeAndText(IdentifyingAttributes identifyingAttributes, Component<T> bestMatch) {
        if (bestMatch == null) {
            return false;
        }
        return this.sameType(bestMatch, identifyingAttributes) && this.sameText(bestMatch, identifyingAttributes);
    }

    private void logError(IdentifyingAttributes identifyingAttributes) {
        logger.error("Could not find component {} in {} window(s): ", (Object)identifyingAttributes.toFullString(), (Object)this.targetableWindows.size());
        for (int i = 0; i < this.targetableWindows.size(); ++i) {
            RootContainer<T> window = this.targetableWindows.get(i);
            logger.error("Window no. {}: {}", (Object)(i + 1), (Object)window.getTextWithComponents());
        }
    }

    private Component<T> getBestMatchForAllWindows(Element element) {
        double bestMatch = 0.0;
        Component bestMatchComponent = null;
        IdentifyingAttributes identifyingAttributes = element.getIdentifyingAttributes();
        for (RootContainer<T> window : this.targetableWindows) {
            Component currentComponent = window.getBestMatch(identifyingAttributes);
            if (currentComponent == null) continue;
            if (currentComponent.getIdentifyingAttributes().equals(identifyingAttributes)) {
                return currentComponent;
            }
            double currentMatch = currentComponent.match(identifyingAttributes);
            if (!(currentMatch > bestMatch)) continue;
            bestMatch = currentMatch;
            bestMatchComponent = currentComponent;
        }
        return bestMatchComponent;
    }

    private boolean sameText(Component<T> bestMatch, IdentifyingAttributes identifyingAttributes) {
        return Objects.equals(bestMatch.getIdentifyingAttributes().get("text"), identifyingAttributes.get("text"));
    }

    private boolean sameType(Component<T> bestMatch, IdentifyingAttributes identifyingAttributes) {
        return bestMatch.getIdentifyingAttributes().getType().equals(identifyingAttributes.getType());
    }
}

