/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.actions;

import de.retest.recheck.ui.descriptors.ParameterType;
import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ActionParameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    private final String name;
    @XmlAttribute
    private final String value;
    @XmlAttribute
    private final String type;
    @XmlAttribute
    private final String variableName;
    @XmlAttribute
    private final String attributeClass;

    private ActionParameter() {
        this.name = null;
        this.value = null;
        this.type = null;
        this.variableName = null;
        this.attributeClass = null;
    }

    public ActionParameter(String name, String value, String type) {
        this(name, value, type, null);
    }

    public ActionParameter(String name, String value, ParameterType type) {
        this(name, value, type, null);
    }

    public ActionParameter(String name, String value, ParameterType type, String variableName) {
        this(name, value, type, variableName, null);
    }

    public ActionParameter(String name, String value, String type, String variableName) {
        this(name, value, type, variableName, null);
    }

    public ActionParameter(String name, String value, ParameterType type, String variableName, String attributeClass) {
        this(name, value, type.toString(), variableName, attributeClass);
    }

    public ActionParameter(String name, String value, String type, String variableName, String attributeClass) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null.");
        }
        this.name = name;
        this.value = value;
        if (type == null) {
            throw new IllegalArgumentException("Type must not be null.");
        }
        this.type = type;
        this.variableName = variableName;
        this.attributeClass = attributeClass;
    }

    public ActionParameter setValue(String value) {
        return new ActionParameter(this.name, value, this.type, this.variableName, this.attributeClass);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getAttributeClass() {
        return this.attributeClass;
    }

    public String toString() {
        return "ActionParameter[" + this.name + "(" + this.type + ")=" + this.value + (this.variableName != null ? "(${" + this.variableName + "})" : "") + "]";
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ActionParameter)) {
            return false;
        }
        ActionParameter other = (ActionParameter)object;
        if (!this.name.equals(other.getName())) {
            return false;
        }
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        return Objects.equals(this.value, other.getValue());
    }
}

