/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.actions;

import de.retest.recheck.persistence.Persistable;
import de.retest.recheck.ui.actions.Action;
import de.retest.recheck.ui.actions.ActionList;
import de.retest.recheck.ui.descriptors.GroundState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ActionSequence
extends Persistable
implements ActionList {
    private static final long serialVersionUID = 1L;
    private static final int PERSISTENCE_VERSION = 22;
    @XmlAnyElement(lax=true)
    private final List<Action> actions;
    @XmlElement
    private final String testName;
    @XmlElement
    private final GroundState groundState;

    private ActionSequence() {
        this("", null, new ArrayList<Action>());
    }

    public ActionSequence(String testName, GroundState groundState, List<Action> actions) {
        super(22);
        this.testName = testName;
        this.groundState = groundState;
        this.actions = actions;
    }

    public String getTestname() {
        return this.testName;
    }

    @Override
    public void addAction(Action action, EventObject eo) {
        this.actions.add(action);
    }

    public int size() {
        return this.actions.size();
    }

    public GroundState getGroundState() {
        return this.groundState;
    }

    public List<Action> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    public String toString() {
        return this.testName;
    }

    @Override
    public Action getLastAction() {
        if (this.actions.isEmpty()) {
            return null;
        }
        return this.actions.get(this.actions.size() - 1);
    }
}

