/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.actions;

import de.retest.recheck.ui.actions.Action;
import de.retest.recheck.ui.descriptors.SutState;
import de.retest.recheck.ui.review.ActionChangeSet;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ActionState
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlElement
    private final SutState state;
    @XmlElement
    private final long duration;
    @XmlAnyElement(lax=true)
    private final Action action;

    private ActionState() {
        this.action = null;
        this.state = null;
        this.duration = 0L;
    }

    public ActionState(Action action, SutState resultingState, long duration) {
        assert (action != null);
        assert (resultingState != null);
        this.action = action;
        this.state = resultingState;
        this.duration = duration;
    }

    public SutState getState() {
        return this.state;
    }

    public Action getAction() {
        return this.action;
    }

    public long getDuration() {
        return this.duration;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.action == null ? 0 : this.action.hashCode());
        result = 31 * result + (int)(this.duration ^ this.duration >>> 32);
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActionState other = (ActionState)obj;
        if (this.action == null ? other.action != null : !this.action.equals(other.action)) {
            return false;
        }
        if (this.duration != other.duration) {
            return false;
        }
        return !(this.state == null ? other.state != null : !this.state.equals(other.state));
    }

    public String toString() {
        return this.action.toString();
    }

    public ActionState applyChanges(ActionChangeSet actionChangeSet) {
        Action action = this.getAction().applyChanges(actionChangeSet);
        SutState resultingState = this.getState().applyChanges(actionChangeSet);
        return new ActionState(action, resultingState, this.duration);
    }
}

