/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.actions;

import de.retest.recheck.ui.actions.ActionState;
import de.retest.recheck.ui.descriptors.SutState;
import de.retest.recheck.ui.review.ActionChangeSet;
import de.retest.recheck.ui.review.TestChangeSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ActionStateSequence
implements Serializable {
    private static final long serialVersionUID = 3L;
    @XmlElement
    private final SutState initialState;
    @XmlElement
    private final List<ActionState> actionStates;
    @XmlElement
    private final String name;
    @XmlElement
    private final long sumDuration;
    @XmlElement
    private long startupDuration;

    private ActionStateSequence() {
        this.initialState = null;
        this.actionStates = null;
        this.name = null;
        this.sumDuration = 0L;
    }

    public ActionStateSequence(SutState initialState, List<ActionState> actionStates, String name, long sumDuration, long startupDuration) {
        this.initialState = initialState;
        assert (initialState != null) : "Initial state cannot be null!";
        this.actionStates = actionStates;
        assert (actionStates != null) : "ActionStates cannot be null!";
        this.name = name;
        this.sumDuration = sumDuration;
        this.startupDuration = startupDuration;
    }

    public SutState getInitialState() {
        return this.initialState;
    }

    public List<ActionState> getActionStates() {
        return this.actionStates;
    }

    public String getName() {
        return this.name;
    }

    public long getSumDuration() {
        return this.sumDuration;
    }

    public long getStartupDuration() {
        return this.startupDuration;
    }

    public ActionStateSequence applyChanges(TestChangeSet testChangeSet) {
        SutState newInitialState = ActionStateSequence.manipulateInitialState(this.initialState, testChangeSet);
        ArrayList<ActionState> newActionStates = new ArrayList<ActionState>();
        for (int i = 0; i < this.actionStates.size(); ++i) {
            newActionStates.add(ActionStateSequence.manipulate(this.actionStates.get(i), testChangeSet.getActionChangeSet(i)));
        }
        return new ActionStateSequence(newInitialState, newActionStates, this.name, this.sumDuration, this.startupDuration);
    }

    private static SutState manipulateInitialState(SutState initialState, TestChangeSet testChangeSet) {
        if (testChangeSet.containsInitialStateChangeSet()) {
            return initialState.applyChanges(testChangeSet.getInitialStateChangeSet());
        }
        return initialState;
    }

    private static ActionState manipulate(ActionState actionWithUiState, ActionChangeSet actionChangeSet) {
        if (actionChangeSet != null) {
            return actionWithUiState.applyChanges(actionChangeSet);
        }
        return actionWithUiState;
    }
}

