/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.actions;

import de.retest.recheck.ui.Environment;
import de.retest.recheck.ui.actions.AbstractAction;
import de.retest.recheck.ui.actions.Action;
import de.retest.recheck.ui.actions.ActionExecutionResult;
import de.retest.recheck.ui.actions.ActionParameter;
import de.retest.recheck.ui.actions.TargetNotFoundException;
import de.retest.recheck.ui.components.Component;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.ParameterType;
import de.retest.recheck.ui.descriptors.StringAttribute;
import de.retest.recheck.ui.image.Screenshot;
import de.retest.recheck.ui.review.ActionChangeSet;
import de.retest.recheck.util.ObjectUtil;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
public class ParameterizedAction
extends AbstractAction {
    private static final Logger logger = LoggerFactory.getLogger(ParameterizedAction.class);
    private static final long serialVersionUID = 1L;
    public static final String ACTION_CLASS_PARAM = "actionClass";
    public static final String DESCRIPTION_PARAM = "description";
    @XmlElement
    private final Set<ActionParameter> actionParameter;

    protected ParameterizedAction() {
        this.actionParameter = new HashSet<ActionParameter>();
    }

    public ParameterizedAction(ParameterizedAction data) {
        this(data.getTargetElement(), data.getWindowsScreenshots(), data.getActionParameter());
    }

    public ParameterizedAction(Element element, Screenshot[] windowScreenshots, Class<?> actionClass, String description, ActionParameter ... params) {
        super(element, windowScreenshots);
        if (actionClass == null) {
            throw new IllegalArgumentException("Cannot create a ParameterizedAction without action class!");
        }
        if (description == null) {
            throw new IllegalArgumentException("Cannot create a ParameterizedAction without description!");
        }
        HashSet<ActionParameter> tmpActionParams = new HashSet<ActionParameter>(Arrays.asList(params));
        tmpActionParams.add(ParameterizedAction.actionClassParam(actionClass));
        tmpActionParams.add(ParameterizedAction.descriptionParam(description));
        this.actionParameter = Collections.unmodifiableSet(tmpActionParams);
    }

    ParameterizedAction(Element element, Screenshot[] windowScreenshots, Set<ActionParameter> params) {
        super(element, windowScreenshots);
        this.actionParameter = new HashSet<ActionParameter>(params);
        if (this.getParameter(ACTION_CLASS_PARAM) == null) {
            throw new IllegalArgumentException("Cannot create a ParameterizedAction without action class!");
        }
        if (this.getParameter(DESCRIPTION_PARAM) == null) {
            throw new IllegalArgumentException("Cannot create a ParameterizedAction without description!");
        }
    }

    public Set<ActionParameter> getActionParameter() {
        return new HashSet<ActionParameter>(this.actionParameter);
    }

    @Override
    public Action applyChanges(ActionChangeSet reviewResult) {
        return new ParameterizedAction(this.element.applyChanges(reviewResult), this.getWindowsScreenshots(), new HashSet<ActionParameter>(this.actionParameter));
    }

    public ParameterizedAction applyChanges(ActionParameter ... changedParam) {
        Map parameterToReplaceByName = Arrays.stream(changedParam).collect(Collectors.toMap(ActionParameter::getName, Function.identity()));
        Set<ActionParameter> newActionParameter = this.actionParameter.stream().map(param -> parameterToReplaceByName.getOrDefault(param.getName(), param)).collect(Collectors.toSet());
        return new ParameterizedAction(this.element, this.getWindowsScreenshots(), newActionParameter);
    }

    public ParameterizedAction applyChanges(Set<ActionParameter> changedParameters) {
        return new ParameterizedAction(this.element, this.getWindowsScreenshots(), changedParameters);
    }

    @Override
    public String createDescription() {
        return (String)this.getParameterValue(DESCRIPTION_PARAM);
    }

    public ActionParameter getParameter(String name) {
        for (ActionParameter param : this.actionParameter) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public <T> T getParameterValue(String name) {
        ActionParameter parameter = this.getParameter(name);
        if (parameter == null) {
            return null;
        }
        String value = parameter.getValue();
        ParameterType parameterType = ParameterType.getType(parameter.getType());
        try {
            Object parse = parameterType.parse(value);
            return (T)parse;
        }
        catch (Exception e) {
            logger.error("Exception parsing parameter {} of type {} with value {}.", new Object[]{name, value, parameterType});
            return null;
        }
    }

    @Override
    public void execute(Component<?> component) throws TargetNotFoundException {
        Action action = this.getAction();
        action.execute(component);
    }

    @Override
    public <T> ActionExecutionResult execute(Environment<T> environment) {
        if (this.isExecuteNotOverwritten()) {
            return super.execute(environment);
        }
        Action action = this.getAction();
        return action.execute(environment);
    }

    private boolean isExecuteNotOverwritten() {
        try {
            return this.getActionClass().getMethod("execute", Environment.class).getDeclaringClass().equals(ParameterizedAction.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Action getAction() {
        try {
            Class<?> actionClass = this.getActionClass();
            if (actionClass.equals(ParameterizedAction.class)) {
                throw new RuntimeException("Cannot execute a ParameterizedAction directly, subclass and pass the class in the constructor!");
            }
            Constructor<?> constructor = actionClass.getConstructor(ParameterizedAction.class);
            return (Action)constructor.newInstance(this);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception execution action " + this.createDescription(), e);
        }
    }

    protected static ActionParameter actionClassParam(Class<?> clazz) {
        return new ActionParameter(ACTION_CLASS_PARAM, clazz.getName(), StringAttribute.parameterTypeClass);
    }

    protected static ActionParameter descriptionParam(String description) {
        return new ActionParameter(DESCRIPTION_PARAM, description, StringAttribute.parameterTypeString);
    }

    public Class<?> getActionClass() {
        return (Class)this.getParameterValue(ACTION_CLASS_PARAM);
    }

    @Override
    public String toString() {
        return (String)this.getParameterValue(DESCRIPTION_PARAM);
    }

    @Override
    public int hashCode() {
        int result = 0;
        for (ActionParameter param : this.actionParameter) {
            result = ObjectUtil.nextHashCode(result, Integer.valueOf(param.hashCode()));
        }
        return result;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ParameterizedAction)) {
            return false;
        }
        ParameterizedAction other = (ParameterizedAction)object;
        if (this.actionParameter.size() != other.actionParameter.size()) {
            return false;
        }
        for (ActionParameter param : this.actionParameter) {
            ActionParameter otherParam;
            if (param.equals(otherParam = other.getParameter(param.getName()))) continue;
            return false;
        }
        return true;
    }
}

