/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.actions;

import de.retest.recheck.ui.actions.Action;
import de.retest.recheck.ui.actions.TargetNotFoundException;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.image.Screenshot;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TargetNotFoundWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAnyElement(lax=true)
    private final Action action;
    @XmlElement
    private final Element bestMatch;
    @XmlElement
    private final Screenshot[] windowsScreenshots;
    @XmlElement
    private final String message;
    @XmlTransient
    private TargetNotFoundException tnfe;

    private TargetNotFoundWrapper() {
        this.action = null;
        this.bestMatch = null;
        this.message = "";
        this.windowsScreenshots = new Screenshot[0];
    }

    public TargetNotFoundWrapper(TargetNotFoundException tnfe) {
        this.action = tnfe.getAction();
        this.bestMatch = tnfe.getBestMatch();
        this.windowsScreenshots = tnfe.getActualWindowsScreenshots();
        this.message = tnfe.getMessage();
        this.tnfe = tnfe;
    }

    public Element getMissingTarget() {
        return this.action != null ? this.action.getTargetElement() : null;
    }

    public Screenshot[] getExpectedWindowsScreenshots() {
        return this.action != null ? this.action.getWindowsScreenshots() : new Screenshot[]{};
    }

    public Screenshot[] getActualWindowsScreenshots() {
        return this.windowsScreenshots;
    }

    public Element getBestMatch() {
        return this.bestMatch;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getTargetNotFoundException() {
        return this.tnfe;
    }

    public String toString() {
        if (this.action == null) {
            return this.getClass().getName() + ": " + this.message;
        }
        return this.getClass().getName() + ": Action " + this.action.toString() + ": " + this.message;
    }
}

