/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.descriptors;

import de.retest.recheck.ui.Path;
import de.retest.recheck.ui.descriptors.Attributes;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.descriptors.IdentifyingAttributesAdapter;
import de.retest.recheck.ui.descriptors.RenderContainedElementsAdapter;
import de.retest.recheck.ui.descriptors.StateAttributesAdapter;
import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.ui.image.Screenshot;
import de.retest.recheck.ui.review.ActionChangeSet;
import de.retest.recheck.util.RetestIdUtil;
import java.beans.Transient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.ObjectUtils;
import org.eclipse.persistence.oxm.annotations.XmlInverseReference;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Element
implements Serializable,
Comparable<Element> {
    protected static final long serialVersionUID = 2L;
    @XmlAttribute
    protected final String retestId;
    @XmlInverseReference(mappedBy="containedElements")
    private final Element parent;
    @XmlJavaTypeAdapter(value=IdentifyingAttributesAdapter.class)
    @XmlElement
    protected final IdentifyingAttributes identifyingAttributes;
    @XmlJavaTypeAdapter(value=StateAttributesAdapter.class)
    @XmlElement
    protected final Attributes attributes;
    @XmlElement
    @XmlJavaTypeAdapter(value=RenderContainedElementsAdapter.class)
    protected final List<Element> containedElements;
    @XmlElement
    protected Screenshot screenshot;
    @XmlTransient
    private transient Integer hashCodeCache;

    protected Element() {
        this.retestId = "";
        this.parent = null;
        this.identifyingAttributes = null;
        this.attributes = null;
        this.containedElements = new ArrayList<Element>();
    }

    Element(String retestId, Element parent, IdentifyingAttributes identifyingAttributes, Attributes attributes, Screenshot screenshot) {
        RetestIdUtil.validate(retestId, identifyingAttributes);
        this.retestId = retestId;
        this.parent = Objects.requireNonNull(parent, "Parent must not be null");
        this.identifyingAttributes = Objects.requireNonNull(identifyingAttributes, "IdentifyingAttributes must not be null");
        this.attributes = Objects.requireNonNull(attributes, "Attributes must not be null");
        this.containedElements = new ArrayList<Element>();
        this.screenshot = screenshot;
    }

    public static Element create(String retestId, Element parent, IdentifyingAttributes identifyingAttributes, Attributes attributes) {
        return new Element(retestId, parent, identifyingAttributes, attributes, null);
    }

    public static Element create(String retestId, Element parent, IdentifyingAttributes identifyingAttributes, Attributes attributes, Screenshot screenshot) {
        return new Element(retestId, parent, identifyingAttributes, attributes, screenshot);
    }

    public Element applyChanges(ActionChangeSet actionChangeSet) {
        if (actionChangeSet == null) {
            return this;
        }
        IdentifyingAttributes newIdentAttributes = this.identifyingAttributes.applyChanges(actionChangeSet.getIdentAttributeChanges().getAll(this.identifyingAttributes));
        Attributes newAttributes = this.attributes.applyChanges(actionChangeSet.getAttributesChanges().getAll(this.identifyingAttributes));
        List<Element> newContainedElements = this.createNewElementList(actionChangeSet, newIdentAttributes);
        Element element = Element.create(this.retestId, this, newIdentAttributes, newAttributes);
        element.addChildren(newContainedElements);
        return element;
    }

    protected List<Element> createNewElementList(ActionChangeSet actionChangeSet, IdentifyingAttributes newIdentAttributes) {
        List<Element> newContainedElements = this.containedElements;
        newContainedElements = this.removeDeleted(actionChangeSet, newContainedElements);
        newContainedElements = this.applyChangesToContainedElements(actionChangeSet, newIdentAttributes, newContainedElements);
        newContainedElements = this.addInserted(actionChangeSet, newIdentAttributes, newContainedElements);
        return newContainedElements;
    }

    private List<Element> removeDeleted(ActionChangeSet actionChangeSet, List<Element> oldContainedElements) {
        Set<IdentifyingAttributes> deletedChanges = actionChangeSet.getDeletedChanges();
        ArrayList<Element> newContainedElements = new ArrayList<Element>(oldContainedElements.size());
        for (Element oldElement : oldContainedElements) {
            if (deletedChanges.contains(oldElement.getIdentifyingAttributes())) continue;
            newContainedElements.add(oldElement);
        }
        return newContainedElements;
    }

    private List<Element> applyChangesToContainedElements(ActionChangeSet actionChangeSet, IdentifyingAttributes newIdentAttributes, List<Element> oldContainedElements) {
        ArrayList<Element> newContainedElements = new ArrayList<Element>(oldContainedElements.size());
        for (Element oldElement : oldContainedElements) {
            this.addPathChangeToChangeSet(actionChangeSet, newIdentAttributes, oldElement);
            newContainedElements.add(oldElement.applyChanges(actionChangeSet));
        }
        return newContainedElements;
    }

    private void addPathChangeToChangeSet(ActionChangeSet actionChangeSet, IdentifyingAttributes newIdentAttributes, Element oldElement) {
        if (ObjectUtils.notEqual((Object)this.identifyingAttributes.getPathTyped(), (Object)newIdentAttributes.getPathTyped())) {
            Path oldPath = oldElement.identifyingAttributes.getPathTyped();
            Path newPath = Path.fromString(newIdentAttributes.getPath() + "/" + oldElement.identifyingAttributes.getPathElement().toString());
            actionChangeSet.getIdentAttributeChanges().add(oldElement.identifyingAttributes, new AttributeDifference("path", oldPath, newPath));
        }
    }

    private List<Element> addInserted(ActionChangeSet actionChangeSet, IdentifyingAttributes newIdentAttributes, List<Element> newContainedElements) {
        for (Element insertedElement : actionChangeSet.getInsertedChanges()) {
            if (!Element.isParent(newIdentAttributes, insertedElement.identifyingAttributes)) continue;
            newContainedElements.add(insertedElement);
        }
        return newContainedElements;
    }

    public int countAllContainedElements() {
        int result = 1;
        for (Element element : this.containedElements) {
            result += element.countAllContainedElements();
        }
        return result;
    }

    public Element getElement(Path path) {
        Path thisPath = this.getIdentifyingAttributes().getPathTyped();
        if (thisPath.equals(path)) {
            return this;
        }
        if (thisPath.isParent(path)) {
            for (Element element : this.containedElements) {
                Element contained = element.getElement(path);
                if (contained == null) continue;
                return contained;
            }
        }
        return null;
    }

    public IdentifyingAttributes getIdentifyingAttributes() {
        return this.identifyingAttributes;
    }

    public List<Element> getContainedElements() {
        return this.containedElements;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public String getRetestId() {
        return this.retestId;
    }

    public Screenshot getScreenshot() {
        return this.screenshot;
    }

    public void setScreenshot(Screenshot screenshot) {
        if (screenshot == null && this.screenshot != null) {
            throw new RuntimeException("Screenshot can only be replaced, not deleted.");
        }
        this.screenshot = screenshot;
    }

    public boolean hasContainedElements() {
        return !this.containedElements.isEmpty();
    }

    private static boolean isParent(IdentifyingAttributes parentIdentAttributes, IdentifyingAttributes containedIdentAttributes) {
        return parentIdentAttributes.getPathTyped().equals(containedIdentAttributes.getParentPathTyped());
    }

    @Transient
    public Element getParent() {
        return this.parent;
    }

    public void addChildren(Element ... children) {
        this.containedElements.addAll(Arrays.asList(children));
    }

    public void addChildren(List<Element> children) {
        this.containedElements.addAll(children);
    }

    @Override
    public int compareTo(Element other) {
        int result = this.identifyingAttributes.compareTo(other.getIdentifyingAttributes());
        if (result != 0) {
            return result;
        }
        return this.attributes.compareTo(other.getAttributes());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Element other = (Element)obj;
        if (!this.identifyingAttributes.equals(other.identifyingAttributes)) {
            return false;
        }
        if (!this.attributes.equals(other.attributes)) {
            return false;
        }
        return this.containedElements.equals(other.containedElements);
    }

    public int hashCode() {
        if (this.hashCodeCache == null) {
            this.hashCodeCache = Objects.hash(this.identifyingAttributes, this.attributes, this.containedElements);
        }
        return this.hashCodeCache;
    }

    public String toString() {
        return this.identifyingAttributes.toString();
    }
}

