/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.descriptors;

import de.retest.recheck.ui.components.Component;
import de.retest.recheck.ui.components.ComponentContainer;
import de.retest.recheck.ui.components.RootContainer;
import de.retest.recheck.ui.descriptors.Attributes;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.descriptors.RetestIdProviderUtil;
import de.retest.recheck.ui.descriptors.RootElement;
import de.retest.recheck.ui.image.Screenshot;
import java.util.ArrayList;
import java.util.List;

public class ElementUtil {
    public static List<Element> flattenAllElements(List<Element> elements) {
        ArrayList<Element> flattened = new ArrayList<Element>();
        for (Element element : elements) {
            flattened.add(element);
            flattened.addAll(ElementUtil.flattenChildElements(element));
        }
        return flattened;
    }

    public static Element toElement(Component<?> component) {
        IdentifyingAttributes identifyingAttributes = component.retrieveIdentifyingAttributes();
        Attributes attributes = component.retrieveAttributes();
        Screenshot screenshot = component.createScreenshot();
        ArrayList<Element> containedComponents = new ArrayList<Element>();
        if (component instanceof ComponentContainer) {
            for (Component containedComponent : ((ComponentContainer)component).getChildComponents()) {
                containedComponents.add(containedComponent.getElement());
            }
        }
        String retestId = RetestIdProviderUtil.getRetestId(identifyingAttributes);
        Element element = Element.create(retestId, new Element(), identifyingAttributes, attributes, screenshot);
        element.addChildren(containedComponents);
        return element;
    }

    public static RootElement toRootElement(RootContainer<?> window) {
        IdentifyingAttributes identifyingAttributes = window.retrieveIdentifyingAttributes();
        Attributes attributes = window.retrieveAttributes();
        Screenshot screenshot = window.createScreenshot();
        ArrayList<Element> containedComponents = new ArrayList<Element>();
        for (Component containedComponent : window.getChildComponents()) {
            containedComponents.add(containedComponent.getElement());
        }
        String screen = window.getScreenId();
        int screenId = screen.hashCode();
        String title = window.getText();
        String retestId = RetestIdProviderUtil.getRetestId(identifyingAttributes);
        RootElement rootElement = new RootElement(retestId, identifyingAttributes, attributes, screenshot, screen, screenId, title);
        rootElement.addChildren(containedComponents);
        return rootElement;
    }

    public static List<Element> flattenChildElements(Element element) {
        ArrayList<Element> flattened = new ArrayList<Element>();
        for (Element childElement : element.getContainedElements()) {
            flattened.add(childElement);
            flattened.addAll(ElementUtil.flattenChildElements(childElement));
        }
        return flattened;
    }

    public static boolean pathEquals(Element element0, Element element1) {
        return element0.getIdentifyingAttributes().getPathTyped().equals(element1.getIdentifyingAttributes().getPathTyped());
    }
}

