/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.descriptors;

import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.ui.image.Screenshot;
import de.retest.recheck.util.ObjectUtil;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ScreenshotAttributeDifference
extends AttributeDifference {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    private final String strategyName;
    @XmlAttribute
    private final double match;

    private ScreenshotAttributeDifference() {
        this.strategyName = null;
        this.match = 0.0;
    }

    public ScreenshotAttributeDifference(Screenshot expected, Screenshot actual, String strategyName, double match) {
        super("screenshot", expected, actual);
        this.strategyName = strategyName;
        this.match = match;
    }

    public String getStrategyName() {
        return this.strategyName;
    }

    public double getMatch() {
        return this.match;
    }

    @Override
    public int hashCode() {
        return ObjectUtil.nextHashCode(ObjectUtil.nextHashCode(super.hashCode(), (Serializable)((Object)this.strategyName)), Double.valueOf(this.match));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScreenshotAttributeDifference other = (ScreenshotAttributeDifference)obj;
        return Objects.equals(this.getKey(), other.getKey()) && Objects.equals(this.getExpected(), other.getExpected()) && Objects.equals(this.getActual(), other.getActual()) && Objects.equals(this.getStrategyName(), other.getStrategyName());
    }

    @Override
    public String toString() {
        return this.getKey() + " = [expected=" + this.getExpected() + ", actual=" + this.getActual() + ", " + this.strategyName + " found " + String.format(Locale.ENGLISH, "%.2f%%", 100.0 * this.match) + " match]";
    }
}

