/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.descriptors;

import de.retest.recheck.ui.descriptors.Attribute;
import de.retest.recheck.ui.descriptors.ParameterizedAttribute;
import de.retest.recheck.ui.descriptors.StringAttribute;
import de.retest.recheck.util.StringSimilarity;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class TextAttribute
extends StringAttribute {
    private static final long serialVersionUID = 1L;

    protected TextAttribute() {
    }

    public TextAttribute(String key, String value) {
        this(key, value, null);
    }

    public TextAttribute(String key, String value, String variableName) {
        super(key, value, variableName);
    }

    @Override
    public double match(Attribute other) {
        if (!(other instanceof TextAttribute)) {
            return 0.0;
        }
        assert (other.getKey().equals(this.getKey()));
        return StringSimilarity.textSimilarity(this.getValue(), ((StringAttribute)other).getValue());
    }

    @Override
    public Attribute applyChanges(Serializable actual) {
        return new TextAttribute(this.getKey(), (String)((Object)actual), this.getVariableName());
    }

    @Override
    public ParameterizedAttribute applyVariableChange(String variableName) {
        return new TextAttribute(this.getKey(), this.getValue(), variableName);
    }
}

