/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.diff;

import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.diff.Match;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Alignment {
    private static final Logger logger = LoggerFactory.getLogger(Alignment.class);
    private final Map<Element, Element> alignment;
    private final Map<Element, Element> expectedMapOfElementTree = new HashMap<Element, Element>();
    private final Map<Element, Element> actualMapOfElementTree = new HashMap<Element, Element>();

    private Alignment(Element expectedComponent, Element actualComponent) {
        List<Element> expectedComponents = Alignment.flattenLeafElements(expectedComponent, this.expectedMapOfElementTree);
        List<Element> actualComponents = Alignment.flattenLeafElements(actualComponent, this.actualMapOfElementTree);
        logger.debug("Creating assignment of old to new components, trying to find differences. We are comparing {} with {} components.", (Object)expectedComponents.size(), (Object)actualComponents.size());
        this.alignment = this.createAlignment(expectedComponents, Alignment.toMapping(actualComponents));
        this.addParentAlignment();
    }

    private void addParentAlignment() {
        HashMap<Element, Element> alignmentCopy = new HashMap<Element, Element>(this.alignment);
        for (Map.Entry alignmentPair : alignmentCopy.entrySet()) {
            List<Element> expectedParents = this.getParents((Element)alignmentPair.getKey(), this.expectedMapOfElementTree);
            List<Element> actualParents = this.getParents((Element)alignmentPair.getValue(), this.actualMapOfElementTree);
            Map<Element, Element> parentAlignment = this.createAlignment(expectedParents, Alignment.toMapping(actualParents));
            for (Map.Entry<Element, Element> parentAlignmentPair : parentAlignment.entrySet()) {
                Element aligned = this.alignment.get(parentAlignmentPair.getKey());
                if (aligned == null) {
                    this.alignment.put(parentAlignmentPair.getKey(), parentAlignmentPair.getValue());
                    continue;
                }
                if (parentAlignmentPair.getValue() == null || !(Alignment.match(parentAlignmentPair.getKey(), parentAlignmentPair.getValue()) > Alignment.match(parentAlignmentPair.getKey(), aligned))) continue;
                this.alignment.put(parentAlignmentPair.getKey(), parentAlignmentPair.getValue());
            }
        }
    }

    private List<Element> getParents(Element element, Map<Element, Element> treeMap) {
        ArrayList<Element> result = new ArrayList<Element>();
        Element parent = treeMap.get(element);
        while (parent != null) {
            result.add(parent);
            parent = treeMap.get(parent);
        }
        return result;
    }

    public static Alignment createAlignment(Element expectedComponent, Element actualComponent) {
        return new Alignment(expectedComponent, actualComponent);
    }

    private static List<Element> flattenLeafElements(Element element, Map<Element, Element> mapOfElementTree) {
        ArrayList<Element> flattened = new ArrayList<Element>();
        for (Element childElement : element.getContainedElements()) {
            mapOfElementTree.put(childElement, element);
            if (!childElement.hasContainedElements()) {
                flattened.add(childElement);
                continue;
            }
            flattened.addAll(Alignment.flattenLeafElements(childElement, mapOfElementTree));
        }
        return flattened;
    }

    static Map<Element, Element> toMapping(List<Element> actualElements) {
        LinkedHashMap<Element, Element> result = new LinkedHashMap<Element, Element>();
        for (Element element : actualElements) {
            Element oldMapping = result.put(element, element);
            if (oldMapping == null) continue;
            throw new RuntimeException("Elements should be unique, but those returned the same hash: " + element + " - " + oldMapping);
        }
        return result;
    }

    private Map<Element, Element> createAlignment(List<Element> expectedComponents, Map<Element, Element> actualComponents) {
        HashMap<Element, Match> matches = new HashMap<Element, Match>();
        Stack<Element> componentsToAlign = Alignment.toStack(expectedComponents);
        HashMap<Element, Element> alignment = new HashMap<Element, Element>();
        while (!componentsToAlign.isEmpty()) {
            Element expected = componentsToAlign.pop();
            TreeSet<Match> bestMatches = Alignment.getBestMatches(expected, actualComponents);
            Match bestMatch = bestMatches.pollFirst();
            while (bestMatch != null && matches.containsKey(bestMatch.element)) {
                Match previousMatch = (Match)matches.get(bestMatch.element);
                if (bestMatch.similarity <= previousMatch.similarity) {
                    assert (bestMatch.similarity != 1.0) : "bestMatch and previousMatch have a match of 100%? At least paths should differ! " + bestMatch.element.getIdentifyingAttributes().toFullString() + " == " + previousMatch.element.getIdentifyingAttributes().toFullString();
                    bestMatch = bestMatches.pollFirst();
                    continue;
                }
                alignment.remove(previousMatch.element);
                componentsToAlign.add(previousMatch.element);
                break;
            }
            if (bestMatch == null) {
                alignment.put(expected, null);
                continue;
            }
            alignment.put(expected, bestMatch.element);
            matches.put(bestMatch.element, new Match(bestMatch.similarity, expected));
        }
        return alignment;
    }

    private static Stack<Element> toStack(List<Element> expectedElements) {
        Stack<Element> componentsToAlign = new Stack<Element>();
        componentsToAlign.addAll(expectedElements);
        Collections.reverse(componentsToAlign);
        return componentsToAlign;
    }

    private static TreeSet<Match> getBestMatches(Element expected, Map<Element, Element> actualElements) {
        TreeSet<Match> result = new TreeSet<Match>();
        Element identityResult = actualElements.get(expected);
        if (identityResult != null) {
            result.add(new Match(1.0, identityResult));
        } else {
            for (Element element : actualElements.keySet()) {
                double similarity = Alignment.match(expected, element);
                if (similarity == 1.0) {
                    result.add(new Match(similarity, element));
                    return result;
                }
                result.add(new Match(similarity, element));
            }
        }
        return result;
    }

    private static double match(Element expected, Element bestMatch) {
        return expected.getIdentifyingAttributes().match(bestMatch.getIdentifyingAttributes());
    }

    public Element get(Element element) {
        return this.alignment.get(element);
    }

    public String toString() {
        return this.alignment.toString();
    }

    public int hashCode() {
        return this.alignment.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Alignment) {
            return this.alignment.equals(((Alignment)other).alignment);
        }
        return false;
    }
}

