/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.diff;

import com.google.common.base.Joiner;
import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.ui.diff.Difference;
import de.retest.recheck.ui.diff.ElementDifference;
import de.retest.recheck.util.ListMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AttributesDifference
implements Difference {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    private final String differenceId;
    @XmlElement
    private final List<AttributeDifference> differences;

    private AttributesDifference() {
        this.differenceId = null;
        this.differences = null;
    }

    AttributesDifference(List<AttributeDifference> differences) {
        this.differences = Collections.unmodifiableList(differences);
        this.differenceId = AttributeDifference.getSumIdentifier(differences);
    }

    @Override
    public String toString() {
        return "{" + Joiner.on((String)", ").join(this.differences) + "}";
    }

    @Override
    public int size() {
        return this.differences.size();
    }

    @Override
    public List<ElementDifference> getNonEmptyDifferences() {
        return Collections.emptyList();
    }

    @Override
    public List<ElementDifference> getElementDifferences() {
        return Collections.emptyList();
    }

    public Map<String, Serializable> expected() {
        ListMap<String, Serializable> expected = new ListMap<String, Serializable>();
        for (AttributeDifference difference : this.differences) {
            expected.put(difference.getKey(), difference.getExpected());
        }
        return expected;
    }

    public Map<String, Serializable> actual() {
        ListMap<String, Serializable> actual = new ListMap<String, Serializable>();
        for (AttributeDifference difference : this.differences) {
            actual.put(difference.getKey(), difference.getActual());
        }
        return actual;
    }

    public List<AttributeDifference> getDifferences() {
        return this.differences;
    }

    public String getIdentifier() {
        return this.differenceId;
    }
}

