/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.diff;

import de.retest.recheck.ignore.ShouldIgnore;
import de.retest.recheck.persistence.xml.XmlTransformer;
import de.retest.recheck.ui.descriptors.AttributeUtil;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.ui.diff.AttributesDifference;
import de.retest.recheck.ui.diff.Difference;
import de.retest.recheck.ui.diff.IdentifyingAttributesDifference;
import de.retest.recheck.ui.diff.InsertedDeletedElementDifference;
import de.retest.recheck.ui.diff.LeafDifference;
import de.retest.recheck.ui.image.ImageUtils;
import de.retest.recheck.ui.image.Screenshot;
import de.retest.recheck.util.ChecksumCalculator;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.Marshaller;

public class ElementDifference
implements Difference,
Comparable<ElementDifference> {
    protected static final long serialVersionUID = 2L;
    protected final AttributesDifference attributesDifference;
    protected final LeafDifference identifyingAttributesDifference;
    protected Collection<ElementDifference> childDifferences = new ArrayList<ElementDifference>();
    protected final Screenshot expectedScreenshot;
    protected final Screenshot actualScreenshot;
    private Element element;

    public ElementDifference(Element element, AttributesDifference attributesDifference, LeafDifference identifyingAttributesDifference, Screenshot expectedScreenshot, Screenshot actualScreenshot, Collection<ElementDifference> childDifferences) {
        this.element = element;
        this.attributesDifference = attributesDifference;
        this.identifyingAttributesDifference = identifyingAttributesDifference;
        this.expectedScreenshot = expectedScreenshot;
        this.actualScreenshot = actualScreenshot;
        this.childDifferences.addAll(childDifferences);
    }

    public Screenshot mark(Screenshot screenshot, ShouldIgnore ignore) {
        if (screenshot == null) {
            return null;
        }
        ArrayList<Rectangle> marks = new ArrayList<Rectangle>();
        if (this.childDifferences != null) {
            for (Difference difference : this.childDifferences) {
                for (ElementDifference compDiff : difference.getNonEmptyDifferences()) {
                    if (ignore.shouldIgnoreElement(this.element) || compDiff.getAttributeDifferences(ignore).isEmpty()) continue;
                    marks.add(AttributeUtil.getAbsoluteOutline(compDiff.getIdentifyingAttributes()));
                }
            }
        }
        return ImageUtils.image2Screenshot(screenshot.getPersistenceIdPrefix(), ImageUtils.mark(ImageUtils.screenshot2Image(screenshot), marks));
    }

    public static ElementDifference getCopyWithFlattenedChildDifferenceHierarchy(ElementDifference elementDifference) {
        ElementDifference result = elementDifference;
        while (result.childDifferences.size() == 1 && result.identifyingAttributesDifference == null && result.attributesDifference == null) {
            result = result.childDifferences.iterator().next();
        }
        return result;
    }

    public List<Difference> getImmediateDifferences() {
        ArrayList<Difference> differences = new ArrayList<Difference>();
        if (this.identifyingAttributesDifference != null) {
            differences.add(this.identifyingAttributesDifference);
        }
        if (this.attributesDifference != null) {
            differences.add(this.attributesDifference);
        }
        return differences;
    }

    public List<AttributeDifference> getAttributeDifferences(ShouldIgnore ignore) {
        ArrayList<AttributeDifference> differences = new ArrayList<AttributeDifference>();
        if (this.identifyingAttributesDifference instanceof IdentifyingAttributesDifference) {
            List<AttributeDifference> attributeDifferences = ((IdentifyingAttributesDifference)this.identifyingAttributesDifference).getAttributeDifferences();
            differences.addAll(attributeDifferences);
        }
        if (this.attributesDifference != null) {
            differences.addAll(this.attributesDifference.getDifferences());
        }
        if (ignore == null) {
            return differences;
        }
        return differences.stream().filter(d -> !ignore.shouldIgnoreAttributeDifference(this.element, (AttributeDifference)d)).collect(Collectors.toList());
    }

    public String getIdentifier() {
        String result = this.getIdentifyingAttributes().identifier();
        if (this.identifyingAttributesDifference != null) {
            result = result + ElementDifference.getSumIdentifier(this.identifyingAttributesDifference.getNonEmptyDifferences());
        }
        if (this.attributesDifference != null) {
            result = result + this.attributesDifference.getIdentifier();
        }
        return ChecksumCalculator.getInstance().sha256(result);
    }

    public static String getSumIdentifier(Collection<ElementDifference> differences) {
        String result = "";
        for (ElementDifference difference : differences) {
            result = result + " # " + difference.getIdentifier();
        }
        return ChecksumCalculator.getInstance().sha256(result);
    }

    public boolean hasAttributesDifferences() {
        return this.attributesDifference != null;
    }

    public boolean hasIdentAttributesDifferences() {
        return this.identifyingAttributesDifference instanceof IdentifyingAttributesDifference;
    }

    public boolean isInsertionOrDeletion() {
        return this.identifyingAttributesDifference instanceof InsertedDeletedElementDifference;
    }

    public boolean isInsertion() {
        return this.isInsertionOrDeletion() && ((InsertedDeletedElementDifference)this.identifyingAttributesDifference).isInserted();
    }

    public boolean isDeletion() {
        return this.isInsertionOrDeletion() && !((InsertedDeletedElementDifference)this.identifyingAttributesDifference).isInserted();
    }

    @Override
    public int size() {
        if (this.identifyingAttributesDifference != null || this.attributesDifference != null) {
            return 1;
        }
        if (!this.childDifferences.isEmpty()) {
            int size = 0;
            for (Difference difference : this.childDifferences) {
                size += difference.size();
            }
            return size;
        }
        return 0;
    }

    @Override
    public List<ElementDifference> getNonEmptyDifferences() {
        ArrayList<ElementDifference> result = new ArrayList<ElementDifference>();
        if (this.identifyingAttributesDifference != null || this.attributesDifference != null) {
            result.add(this);
        }
        for (Difference difference : this.childDifferences) {
            result.addAll(difference.getNonEmptyDifferences());
        }
        return result;
    }

    @Override
    public List<ElementDifference> getElementDifferences() {
        ArrayList<ElementDifference> differences = new ArrayList<ElementDifference>();
        differences.add(this);
        for (ElementDifference childDifference : this.childDifferences) {
            differences.addAll(childDifference.getElementDifferences());
        }
        return differences;
    }

    @Override
    public String toString() {
        if (this.identifyingAttributesDifference != null) {
            return this.getIdentifyingAttributes().toString() + ":\n at: " + this.getIdentifyingAttributes().getPath() + ":\n\t" + this.identifyingAttributesDifference;
        }
        if (this.attributesDifference != null) {
            String differences = this.attributesDifference.getDifferences().stream().map(Object::toString).collect(Collectors.joining("\n\t"));
            return this.getIdentifyingAttributes().toString() + ":\n at: " + this.getIdentifyingAttributes().getPath() + ":\n\t" + differences;
        }
        if (!this.childDifferences.isEmpty()) {
            if (this.size() > 50) {
                Difference difference;
                String result = "";
                Iterator<ElementDifference> diffIter = this.childDifferences.iterator();
                for (int diffCnt = 0; diffCnt < 50 && diffIter.hasNext(); diffCnt += difference.size()) {
                    difference = diffIter.next();
                    result = result + difference.toString() + ", ";
                }
                return result.substring(0, result.length() - 2);
            }
            return this.childDifferences.toString();
        }
        return "noDifferences: " + this.getIdentifyingAttributes().toString();
    }

    @Override
    public int compareTo(ElementDifference other) {
        if (this.getIdentifyingAttributes() == null || other.getIdentifyingAttributes() == null) {
            throw new IllegalStateException("Identifying attributes may not be null. Loaded leighweight XML?");
        }
        return this.getIdentifyingAttributes().compareTo(other.getIdentifyingAttributes());
    }

    protected ElementDifference() {
        this.attributesDifference = null;
        this.identifyingAttributesDifference = null;
        this.expectedScreenshot = null;
        this.actualScreenshot = null;
    }

    void beforeMarshal(Marshaller m) {
        if (XmlTransformer.isLightweightMarshaller(m) && this.identifyingAttributesDifference == null && this.attributesDifference == null) {
            List<ElementDifference> childDifferences = this.getClippedNonEmptyChildren();
            childDifferences.remove(this);
            this.childDifferences = childDifferences;
        }
    }

    private List<ElementDifference> getClippedNonEmptyChildren() {
        ArrayList<ElementDifference> result = new ArrayList<ElementDifference>();
        if (this.identifyingAttributesDifference != null || this.attributesDifference != null) {
            result.add(this);
        } else {
            for (ElementDifference childDifference : this.childDifferences) {
                result.addAll(childDifference.getClippedNonEmptyChildren());
            }
        }
        return result;
    }

    public IdentifyingAttributes getIdentifyingAttributes() {
        return this.element.getIdentifyingAttributes();
    }

    public String getRetestId() {
        return this.element.getRetestId();
    }

    public AttributesDifference getAttributesDifference() {
        return this.attributesDifference;
    }

    public LeafDifference getIdentifyingAttributesDifference() {
        return this.identifyingAttributesDifference;
    }

    public Screenshot getExpectedScreenshot() {
        return this.expectedScreenshot;
    }

    public Screenshot getActualScreenshot() {
        return this.actualScreenshot;
    }

    public Element getElement() {
        return this.element;
    }
}

