/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.diff;

import de.retest.recheck.ui.DefaultValueFinder;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.ElementUtil;
import de.retest.recheck.ui.diff.Alignment;
import de.retest.recheck.ui.diff.AttributesDifference;
import de.retest.recheck.ui.diff.AttributesDifferenceFinder;
import de.retest.recheck.ui.diff.Difference;
import de.retest.recheck.ui.diff.ElementDifference;
import de.retest.recheck.ui.diff.IdentifyingAttributesDifferenceFinder;
import de.retest.recheck.ui.diff.InsertedDeletedElementDifference;
import de.retest.recheck.ui.diff.LeafDifference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ElementDifferenceFinder {
    private final IdentifyingAttributesDifferenceFinder identAttrDiffFinder = new IdentifyingAttributesDifferenceFinder();
    private final AttributesDifferenceFinder attributesDifferenceFinder;

    public ElementDifferenceFinder(DefaultValueFinder defaultValueFinder) {
        this.attributesDifferenceFinder = new AttributesDifferenceFinder(defaultValueFinder);
    }

    public Collection<ElementDifference> findChildDifferences(Element expectedComponent, Element actualComponent) {
        Alignment alignment = Alignment.createAlignment(expectedComponent, actualComponent);
        ArrayList<Element> remainingActual = new ArrayList<Element>(ElementUtil.flattenChildElements(actualComponent));
        Collection<ElementDifference> result = this.createHierarchicalStructure(expectedComponent.getContainedElements(), remainingActual, alignment);
        for (Element element : remainingActual) {
            ElementDifference difference = this.differenceFor(null, element, remainingActual, alignment);
            if (difference == null) continue;
            result.add(difference);
        }
        return result;
    }

    private Collection<ElementDifference> createHierarchicalStructure(List<Element> expected, List<Element> remainingActual, Alignment alignment) {
        ArrayList<ElementDifference> result = new ArrayList<ElementDifference>();
        for (Element childComp : expected) {
            Element actualChild;
            ElementDifference difference = this.differenceFor(childComp, actualChild = alignment.get(childComp), remainingActual, alignment);
            if (difference != null) {
                result.add(difference);
            }
            remainingActual.remove(actualChild);
        }
        return result;
    }

    public ElementDifference differenceFor(Element expected, Element actual, List<Element> remainingActual, Alignment alignment) {
        AttributesDifference attributesDifference = null;
        LeafDifference identifyingAttributesDifference = null;
        ArrayList<ElementDifference> childDifferences = new ArrayList<ElementDifference>();
        if (expected == null) {
            identifyingAttributesDifference = InsertedDeletedElementDifference.differenceFor(null, actual);
        } else {
            if (actual == null) {
                identifyingAttributesDifference = InsertedDeletedElementDifference.differenceFor(expected, null);
            } else {
                identifyingAttributesDifference = this.identAttrDiffFinder.differenceFor(expected.getIdentifyingAttributes(), actual.getIdentifyingAttributes());
                attributesDifference = this.attributesDifferenceFinder.differenceFor(expected, actual);
            }
            childDifferences.addAll(this.createHierarchicalStructure(expected.getContainedElements(), remainingActual, alignment));
        }
        if (identifyingAttributesDifference == null && attributesDifference == null && childDifferences.isEmpty()) {
            return null;
        }
        return new ElementDifference(expected == null ? actual : expected, attributesDifference, identifyingAttributesDifference, expected == null ? null : expected.getScreenshot(), actual == null ? null : actual.getScreenshot(), childDifferences);
    }

    public ElementDifference differenceFor(Element expected, Element actual) {
        AttributesDifference attributesDifference = null;
        LeafDifference identifyingAttributesDifference = null;
        ArrayList<ElementDifference> childDifferences = new ArrayList<ElementDifference>();
        if (expected == null) {
            identifyingAttributesDifference = InsertedDeletedElementDifference.differenceFor(null, actual);
        } else if (actual == null) {
            identifyingAttributesDifference = InsertedDeletedElementDifference.differenceFor(expected, null);
        } else {
            identifyingAttributesDifference = this.identAttrDiffFinder.differenceFor(expected.getIdentifyingAttributes(), actual.getIdentifyingAttributes());
            attributesDifference = this.attributesDifferenceFinder.differenceFor(expected, actual);
            childDifferences.addAll(this.findChildDifferences(expected, actual));
        }
        if (identifyingAttributesDifference == null && attributesDifference == null && childDifferences.isEmpty()) {
            return null;
        }
        return new ElementDifference(expected == null ? actual : expected, attributesDifference, identifyingAttributesDifference, expected == null ? null : expected.getScreenshot(), actual == null ? null : actual.getScreenshot(), childDifferences);
    }

    public static List<ElementDifference> getNonEmptyDifferences(List<? extends Difference> differences) {
        ArrayList<ElementDifference> result = new ArrayList<ElementDifference>();
        if (differences != null) {
            for (Difference difference : differences) {
                result.addAll(difference.getNonEmptyDifferences());
            }
        }
        return result;
    }

    public static List<ElementDifference> getElementDifferences(List<? extends Difference> differences) {
        ArrayList<ElementDifference> result = new ArrayList<ElementDifference>();
        for (Difference difference : differences) {
            result.addAll(difference.getElementDifferences());
        }
        return result;
    }
}

