/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.diff;

import de.retest.recheck.ui.descriptors.Attribute;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.ui.diff.ElementDifference;
import de.retest.recheck.ui.diff.LeafDifference;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class IdentifyingAttributesDifference
implements LeafDifference {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    private final String differenceId;
    @XmlElement(name="attribute")
    private final List<Attribute> attributes;
    @XmlElement(name="attributeDifference")
    private final List<AttributeDifference> attributeDifferences;

    private IdentifyingAttributesDifference() {
        this.differenceId = null;
        this.attributes = null;
        this.attributeDifferences = null;
    }

    IdentifyingAttributesDifference(IdentifyingAttributes expectedIdentAttributes, List<AttributeDifference> attributeDifferences) {
        this.attributes = expectedIdentAttributes.getAttributes();
        this.attributeDifferences = attributeDifferences;
        this.differenceId = AttributeDifference.getSumIdentifier(attributeDifferences);
    }

    @Override
    public String toString() {
        StringBuilder expectedDiff = new StringBuilder();
        StringBuilder actualDiff = new StringBuilder();
        for (AttributeDifference attributeDifference : this.attributeDifferences) {
            expectedDiff.append(" expected ").append(attributeDifference.getKey()).append(": ").append(attributeDifference.getExpected());
            actualDiff.append(" actual ").append(attributeDifference.getKey()).append(": ").append(attributeDifference.getActual());
        }
        return expectedDiff.toString().trim() + " - " + actualDiff.toString().trim();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public List<ElementDifference> getNonEmptyDifferences() {
        return Collections.emptyList();
    }

    @Override
    public Serializable getActual() {
        String actualDiff = "";
        for (AttributeDifference attributeDifference : this.attributeDifferences) {
            actualDiff = actualDiff + " " + attributeDifference.getKey() + "=" + attributeDifference.getActual();
        }
        return actualDiff.trim();
    }

    @Override
    public Serializable getExpected() {
        String expectedDiff = "";
        for (AttributeDifference attributeDifference : this.attributeDifferences) {
            expectedDiff = expectedDiff + " " + attributeDifference.getKey() + "=" + attributeDifference.getExpected();
        }
        return expectedDiff.trim();
    }

    @Override
    public List<ElementDifference> getElementDifferences() {
        return Collections.emptyList();
    }

    public List<AttributeDifference> getAttributeDifferences() {
        return this.attributeDifferences;
    }
}

