/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.diff;

import de.retest.recheck.ignore.GloballyIgnoredAttributes;
import de.retest.recheck.ui.descriptors.AdditionalAttributeDifference;
import de.retest.recheck.ui.descriptors.Attribute;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.ui.diff.IdentifyingAttributesDifference;
import de.retest.recheck.util.ObjectUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;

public class IdentifyingAttributesDifferenceFinder {
    public IdentifyingAttributesDifference differenceFor(IdentifyingAttributes expected, IdentifyingAttributes actual) {
        Objects.requireNonNull(expected, "Expected cannot be null!");
        Objects.requireNonNull(actual, "Actual cannot be null!");
        ArrayList<AttributeDifference> attributeDifferences = new ArrayList<AttributeDifference>();
        for (Attribute expectedAttr : expected.getAttributes()) {
            if (Double.compare(expectedAttr.getWeight(), 0.0) == 0 || expectedAttr.isNotVisible()) continue;
            String key = expectedAttr.getKey();
            Serializable expectedValue = expectedAttr.getValue();
            Serializable actualValue = (Serializable)actual.get(key);
            if (GloballyIgnoredAttributes.getInstance().shouldIgnoreAttribute(key)) continue;
            if (key.equals("path")) {
                if (!IdentifyingAttributesDifferenceFinder.pathDiffers(expected, actual)) continue;
                attributeDifferences.add(new AttributeDifference(key, (Serializable)((Object)expected.getPath()), (Serializable)((Object)actual.getPath())));
                continue;
            }
            if (expectedValue == null && actualValue != null) {
                attributeDifferences.add(new AdditionalAttributeDifference(key, actual.getAttribute(key)));
                continue;
            }
            if (!IdentifyingAttributesDifferenceFinder.differs(expectedValue, actualValue)) continue;
            attributeDifferences.add(new AttributeDifference(key, expectedValue, actualValue));
        }
        return attributeDifferences.isEmpty() ? null : new IdentifyingAttributesDifference(expected, attributeDifferences);
    }

    private static boolean pathDiffers(IdentifyingAttributes expected, IdentifyingAttributes actual) {
        return !expected.getPathElement().toString().replace(expected.getParentPath(), actual.getParentPath()).equals(actual.getPathElement().toString());
    }

    private static boolean differs(Object expected, Object actual) {
        return ObjectUtil.isNullOrEmptyString(expected) ? !ObjectUtil.isNullOrEmptyString(actual) : !expected.equals(actual);
    }
}

