/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.diff;

import de.retest.recheck.image.ImageDifferenceCalculator;
import de.retest.recheck.ui.descriptors.RootElement;
import de.retest.recheck.ui.descriptors.ScreenshotAttributeDifference;
import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.ui.diff.AttributesDifference;
import de.retest.recheck.ui.diff.Difference;
import de.retest.recheck.ui.diff.ElementDifference;
import de.retest.recheck.ui.diff.IdentifyingAttributesDifference;
import de.retest.recheck.ui.image.ImageUtils;
import de.retest.recheck.ui.image.Screenshot;
import java.awt.image.BufferedImage;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootElementDifference
implements Difference {
    private static final Logger logger = LoggerFactory.getLogger(RootElementDifference.class);
    private static final long serialVersionUID = 1L;
    private final String differenceId;
    private final String title;
    private final String screen;
    private final int screenId;
    private final int checkedUiComponentCount;
    protected final ElementDifference elementDifference;
    private final Screenshot expectedScreenshot;
    private final Screenshot actualScreenshot;

    private RootElementDifference() {
        this.differenceId = null;
        this.title = null;
        this.screen = null;
        this.screenId = 0;
        this.elementDifference = null;
        this.expectedScreenshot = null;
        this.actualScreenshot = null;
        this.checkedUiComponentCount = 0;
    }

    RootElementDifference(ElementDifference elementDifference, RootElement expectedDescriptor, RootElement actualDescriptor) {
        RootElement instance = expectedDescriptor != null ? expectedDescriptor : actualDescriptor;
        this.title = instance.getTitle();
        this.screen = instance.getScreen();
        this.screenId = instance.getScreenId();
        this.differenceId = elementDifference.getIdentifier();
        this.elementDifference = elementDifference;
        this.expectedScreenshot = elementDifference.getExpectedScreenshot();
        this.actualScreenshot = elementDifference.getActualScreenshot();
        this.checkedUiComponentCount = instance.countAllContainedElements();
    }

    @Override
    public String toString() {
        String result = this.title;
        if (this.elementDifference.identifyingAttributesDifference != null) {
            return result + IdentifyingAttributesDifference.class.getSimpleName() + " " + this.elementDifference.identifyingAttributesDifference;
        }
        if (this.elementDifference.attributesDifference != null) {
            result = result + AttributesDifference.class.getSimpleName() + " " + this.elementDifference.attributesDifference;
        }
        if (!this.elementDifference.childDifferences.isEmpty()) {
            result = result + this.elementDifference.childDifferences.toString();
        }
        return result;
    }

    @Override
    public int size() {
        return this.elementDifference.size();
    }

    @Override
    public List<ElementDifference> getNonEmptyDifferences() {
        return this.elementDifference.getNonEmptyDifferences();
    }

    public ElementDifference getElementDifference() {
        return this.elementDifference;
    }

    @Override
    public List<ElementDifference> getElementDifferences() {
        return this.elementDifference.getElementDifferences();
    }

    public List<ElementDifference> getElementDifferencesGrouped() {
        return this.elementDifference.getElementDifferences();
    }

    public String getIdentifier() {
        return this.differenceId;
    }

    public Screenshot getExpectedScreenshot() {
        ScreenshotAttributeDifference screenshotDiff = this.getScreenshotDifference();
        if (screenshotDiff != null) {
            try {
                Class<?> clazz = Class.forName(screenshotDiff.getStrategyName());
                ImageDifferenceCalculator imgDiffCalc = (ImageDifferenceCalculator)clazz.newInstance();
                BufferedImage differenceImage = imgDiffCalc.compare(this.expectedScreenshot, this.actualScreenshot).getDifferenceImage();
                return ImageUtils.image2Screenshot(this.expectedScreenshot.getPersistenceIdPrefix(), differenceImage);
            }
            catch (Exception e) {
                logger.error("Exception creating difference image.", (Throwable)e);
            }
        }
        return this.expectedScreenshot;
    }

    ScreenshotAttributeDifference getScreenshotDifference() {
        AttributesDifference attributesDifference = this.elementDifference.getAttributesDifference();
        if (attributesDifference != null) {
            List<AttributeDifference> diffs = attributesDifference.getDifferences();
            for (AttributeDifference attrDiff : diffs) {
                if (!(attrDiff instanceof ScreenshotAttributeDifference)) continue;
                return (ScreenshotAttributeDifference)attrDiff;
            }
        }
        return null;
    }

    public Screenshot getActualScreenshot() {
        return this.actualScreenshot;
    }

    public int getCheckedUiComponentCount() {
        return this.checkedUiComponentCount;
    }

    public String getTitle() {
        return this.title;
    }
}

