/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.diff;

import de.retest.recheck.ui.diff.Difference;
import de.retest.recheck.ui.diff.DurationDifference;
import de.retest.recheck.ui.diff.ElementDifference;
import de.retest.recheck.ui.diff.ElementDifferenceFinder;
import de.retest.recheck.ui.diff.RootElementDifference;
import de.retest.recheck.ui.image.Screenshot;
import de.retest.recheck.util.ChecksumCalculator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class StateDifference
implements Difference {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    private final String differenceId;
    @XmlAnyElement(lax=true)
    private final List<RootElementDifference> differences;
    @XmlElement
    private final DurationDifference durationDifference;

    private StateDifference() {
        this.differenceId = null;
        this.differences = new ArrayList<RootElementDifference>();
        this.durationDifference = null;
    }

    public StateDifference(List<RootElementDifference> differences, DurationDifference durationDifference) {
        this.differenceId = StateDifference.getSumIdentifier(differences);
        this.differences = Collections.unmodifiableList(differences);
        this.durationDifference = durationDifference;
    }

    public List<RootElementDifference> getStateDifference() {
        return this.differences;
    }

    public DurationDifference getDurationDifference() {
        return this.durationDifference;
    }

    @Override
    public String toString() {
        return this.differences.toString();
    }

    @Override
    public int size() {
        int size = 0;
        for (Difference difference : this.differences) {
            size += difference.size();
        }
        return size;
    }

    @Override
    public List<ElementDifference> getNonEmptyDifferences() {
        return ElementDifferenceFinder.getNonEmptyDifferences(this.differences);
    }

    @Override
    public List<ElementDifference> getElementDifferences() {
        return ElementDifferenceFinder.getElementDifferences(this.differences);
    }

    public String getIdentifier() {
        return this.differenceId;
    }

    public List<RootElementDifference> getRootElementDifferences() {
        return this.differences;
    }

    public List<Screenshot> getExpectedScreenshots() {
        ArrayList<Screenshot> result = new ArrayList<Screenshot>();
        for (RootElementDifference rootElementDifference : this.differences) {
            result.add(rootElementDifference.getExpectedScreenshot());
        }
        return result;
    }

    public List<Screenshot> getActualScreenshots() {
        ArrayList<Screenshot> result = new ArrayList<Screenshot>();
        for (RootElementDifference rootElementDifference : this.differences) {
            result.add(rootElementDifference.getActualScreenshot());
        }
        return result;
    }

    public static String getSumIdentifier(List<RootElementDifference> differences) {
        String result = "";
        for (RootElementDifference rootElementDifference : differences) {
            result = result + " # " + rootElementDifference.getIdentifier();
        }
        return ChecksumCalculator.getInstance().sha256(result);
    }
}

