/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.image;

import de.retest.recheck.ui.image.Screenshot;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtils {
    private static final Logger logger = LoggerFactory.getLogger(ImageUtils.class);
    public static final String FILE_URI_SCHEME = "file:";
    public static final String JAR_URI_SCHEME = "jar:";
    public static final int MARKING_WIDTH = 2;
    public static final String MAX_SCREENSHOT_HEIGHT_PROP = "de.retest.screenshot.max.height";
    public static final int MAX_SCREENSHOT_HEIGHT_DEFAULT = 2400;
    public static final String MAX_SCREENSHOT_WIDTH_PROP = "de.retest.screenshot.max.width";
    public static final int MAX_SCREENSHOT_WIDTH_DEFAULT = 3600;
    private static final int MAX_SCREENSHOT_HEIGHT = Integer.getInteger("de.retest.screenshot.max.height", 2400);
    private static final int MAX_SCREENSHOT_WIDTH = Integer.getInteger("de.retest.screenshot.max.width", 3600);

    private ImageUtils() {
    }

    public static BufferedImage screenshot2Image(Screenshot input) {
        if (input == null || input.getBinaryData() == null) {
            return null;
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(input.getBinaryData());
            return ImageIO.read(in);
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    public static Screenshot image2Screenshot(String prefix, BufferedImage image) {
        if (image == null) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", baos);
            return new Screenshot(prefix, baos.toByteArray(), Screenshot.ImageType.PNG);
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    public static Screenshot mark(Screenshot image, Rectangle mark) {
        if (image == null) {
            return null;
        }
        return ImageUtils.image2Screenshot(image.getPersistenceIdPrefix(), ImageUtils.mark(ImageUtils.screenshot2Image(image), mark));
    }

    public static BufferedImage mark(BufferedImage image, Rectangle mark) {
        return ImageUtils.mark(image, Collections.singletonList(mark));
    }

    public static BufferedImage mark(BufferedImage image, List<Rectangle> marks) {
        if (image == null) {
            return null;
        }
        BufferedImage result = image;
        int imageOffsetX = 0;
        int imageOffsetY = 0;
        for (Rectangle mark : marks) {
            if (mark == null || mark.height == -1 || mark.width == -1) continue;
            if (mark.x > result.getWidth()) {
                logger.error("Cannot create mark at x value {} with in image of width {}.", (Object)mark.x, (Object)result.getWidth());
                continue;
            }
            if (mark.y > result.getHeight()) {
                logger.error("Cannot create mark at y value {} in image of width {}.", (Object)mark.y, (Object)result.getHeight());
                continue;
            }
            if (mark.x + mark.width > result.getWidth()) {
                logger.debug("Width of mark is bigger than image of width {}, shortening mark.", (Object)result.getWidth());
                mark.width = result.getWidth() - mark.x;
            }
            if (mark.y + mark.height > result.getHeight()) {
                logger.debug("Height of mark is bigger than image of height {}, shortening mark.", (Object)result.getHeight());
                mark.height = result.getHeight() - mark.y;
            }
            mark.x += imageOffsetX;
            mark.y += imageOffsetY;
            int additionalOffsetX = 0;
            int additionalOffsetY = 0;
            int extendedWidth = 0;
            int extendedHeight = 0;
            if (mark.x - 2 < 0) {
                int newImageOffsetX = 2 - mark.x;
                additionalOffsetX = newImageOffsetX - imageOffsetX;
                extendedWidth = imageOffsetX = newImageOffsetX;
                mark.x += imageOffsetX;
            }
            if (mark.x + mark.width + 2 > result.getWidth() + extendedWidth) {
                extendedWidth += 2;
            }
            if (mark.y - 2 < 0) {
                int newImageOffsetY = 2 - mark.y;
                additionalOffsetY = newImageOffsetY - imageOffsetY;
                extendedHeight = imageOffsetY = newImageOffsetY;
                mark.y += imageOffsetY;
            }
            if (mark.y + mark.height + 2 > result.getHeight() + extendedHeight) {
                extendedHeight += 2;
            }
            BufferedImage newResult = new BufferedImage(result.getWidth() + extendedWidth, result.getHeight() + extendedHeight, 2);
            Graphics g = newResult.getGraphics();
            g.drawImage(result, additionalOffsetX, additionalOffsetY, null);
            g.setColor(Color.RED);
            int marking = 4;
            g.fillRect(mark.x - 2, mark.y - 2, 2, mark.height + 4);
            g.fillRect(mark.x - 2, mark.y - 2, mark.width + 4, 2);
            g.fillRect(mark.x + mark.width, mark.y - 2, 2, mark.height + 4);
            g.fillRect(mark.x - 2, mark.y + mark.height, mark.width + 4, 2);
            g.dispose();
            result = newResult;
        }
        return result;
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics bGr = bimage.getGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public static BufferedImage readImage(File file) throws IOException {
        return ImageIO.read(file);
    }

    public static BufferedImage readImage(String path) throws IOException {
        return ImageUtils.readImage(new File(path));
    }

    public static Image scaleProportionallyToMaxWidthHeight(BufferedImage image, int maxWidth, int maxHeight) {
        double widthRatio;
        if (maxWidth >= image.getWidth() && maxHeight >= image.getHeight()) {
            return image;
        }
        double heightRatio = (double)Math.min(maxHeight, image.getHeight()) / (double)image.getHeight();
        if (heightRatio < (widthRatio = (double)Math.min(maxWidth, image.getWidth()) / (double)image.getWidth())) {
            int newHeight = (int)((double)image.getHeight() * heightRatio);
            int newWidth = (int)((double)image.getWidth() * heightRatio);
            return image.getScaledInstance(newWidth, newHeight, 4);
        }
        int newHeight = (int)((double)image.getHeight() * widthRatio);
        int newWidth = (int)((double)image.getWidth() * widthRatio);
        return image.getScaledInstance(newWidth, newHeight, 4);
    }

    public static Image scaleToSameSize(BufferedImage img1, BufferedImage img2) {
        int newWidth = Math.min(img1.getWidth(), img2.getWidth());
        int newHeight = Math.min(img1.getHeight(), img2.getHeight());
        if (newWidth >= img1.getWidth() && newHeight >= img1.getHeight()) {
            return img1;
        }
        return img1.getScaledInstance(newWidth, newHeight, 4);
    }

    public static Screenshot cutImage(Screenshot screenshot, Rectangle bounds) {
        if (screenshot == null) {
            return null;
        }
        return ImageUtils.image2Screenshot(screenshot.getPersistenceIdPrefix(), ImageUtils.cutImage(ImageUtils.screenshot2Image(screenshot), bounds));
    }

    public static BufferedImage cutImage(BufferedImage image, Rectangle bounds) {
        if (image == null || bounds == null) {
            return null;
        }
        if (bounds.x >= image.getWidth()) {
            logger.error("X value of image to cut {} is outside of bigger image with width {}!", (Object)bounds.x, (Object)image.getWidth());
            return null;
        }
        if (bounds.y >= image.getHeight()) {
            logger.error("Y value of image to cut {} is outside of bigger image with height {}!", (Object)bounds.y, (Object)image.getHeight());
            return null;
        }
        if (bounds.x + bounds.width > image.getWidth()) {
            int newWidth = image.getWidth() - bounds.x;
            logger.debug("x coordinate '{}' + width '{}' is outside of image of width '{}', setting width to {}.", new Object[]{bounds.x, bounds.width, image.getWidth(), newWidth});
            bounds.width = newWidth;
        }
        if (bounds.y + bounds.height > image.getHeight()) {
            int newHeight = image.getHeight() - bounds.y;
            logger.debug("y coordinate '{}' + height '{}' is outside of image of height '{}', setting height to {}.", new Object[]{bounds.y, bounds.height, image.getHeight(), newHeight});
            bounds.height = newHeight;
        }
        try {
            return image.getSubimage(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        catch (Exception exc) {
            logger.error("Exception cutting image with width/height {}/{} to bounds {}: ", new Object[]{image.getWidth(), image.getHeight(), bounds, exc});
            return image;
        }
    }

    public static BufferedImage cutToMax(BufferedImage image) {
        if (image.getHeight() < MAX_SCREENSHOT_HEIGHT && image.getWidth() < MAX_SCREENSHOT_WIDTH) {
            return image;
        }
        int imageHeight = Math.min(image.getHeight(), MAX_SCREENSHOT_HEIGHT);
        int imageWidth = Math.min(image.getWidth(), MAX_SCREENSHOT_WIDTH);
        return ImageUtils.cutImage(image, new Rectangle(imageWidth, imageHeight));
    }

    public static void exportScreenshot(Screenshot image, File result) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(result);){
            fos.write(image.getBinaryData());
        }
    }

    public static String removeFileExtension(String filename) {
        String extension = "." + (Object)((Object)Screenshot.ImageType.PNG);
        if (filename.toLowerCase().endsWith(extension.toLowerCase())) {
            return filename.substring(0, filename.length() - extension.length());
        }
        return filename;
    }

    public static String getTextFromIcon(Icon icon) {
        String result = null;
        if (icon != null) {
            result = icon.toString();
            if (result.startsWith(JAR_URI_SCHEME)) {
                result = result.replace(JAR_URI_SCHEME, "");
                result = result.replace(FILE_URI_SCHEME, "");
                String[] splitted = result.split("!");
                return new File(splitted[0]).getName() + "!" + splitted[1];
            }
            if (result.startsWith(FILE_URI_SCHEME)) {
                result = result.replace(FILE_URI_SCHEME, "");
                result = new File(result).getName();
            }
            if (result.startsWith("bundleresource:")) {
                result = result.replaceFirst("bundleresource:\\/\\/[\\d\\.\\w:]+\\/", "");
                return result;
            }
            result = new File(result).getName();
        }
        return result;
    }

    public static BufferedImage toBufferedImage(Icon icon, Component component) {
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        BufferedImage bimage = new BufferedImage(width, height, 2);
        Graphics graphics = bimage.getGraphics();
        icon.paintIcon(component, graphics, 0, 0);
        graphics.dispose();
        return bimage;
    }

    public static Icon scaleIcon(Icon icon, Component component, int width, int height) {
        if (icon == null) {
            return null;
        }
        if (icon.getIconWidth() == width && icon.getIconHeight() == height) {
            return icon;
        }
        BufferedImage image = ImageUtils.toBufferedImage(icon, component);
        Image scaled = ImageUtils.scaleProportionallyToMaxWidthHeight(image, width, height);
        return new ImageIcon(scaled);
    }

    public static BufferedImage resizeImage(BufferedImage image, int width, int height) {
        Image tmp = image.getScaledInstance(width, height, 4);
        BufferedImage resized = new BufferedImage(width, height, 2);
        Graphics2D graphics2D = resized.createGraphics();
        graphics2D.drawImage(tmp, 0, 0, null);
        graphics2D.dispose();
        return resized;
    }

    public static int extractScale() {
        boolean defaultScale = true;
        if (!GraphicsEnvironment.isHeadless() && SystemUtils.IS_OS_MAC) {
            GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice device = environment.getDefaultScreenDevice();
            try {
                Field scale = device.getClass().getDeclaredField("scale");
                if (scale != null) {
                    scale.setAccessible(true);
                    return (Integer)scale.get(device);
                }
            }
            catch (Exception e) {
                logger.error("Unable to get the scale from the graphic environment", (Throwable)e);
            }
        }
        return 1;
    }
}

