/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.image;

import de.retest.recheck.util.ChecksumCalculator;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Screenshot
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private final String persistenceId;
    @XmlTransient
    private byte[] binaryData;
    @XmlElement
    private final ImageType type;
    private static final String PERSISTENCE_ID_SEPARATOR = "_";
    private static final String REGEX_PREFIX_EXTRACT = "_[0-9a-f]{64}$";

    private Screenshot() {
        this.persistenceId = null;
        this.binaryData = null;
        this.type = null;
    }

    public Screenshot(String prefix, byte[] binaryData, ImageType type) {
        if (binaryData == null) {
            throw new NullPointerException("binaryData must not be null.");
        }
        if (type == null) {
            throw new NullPointerException("type must not be null.");
        }
        this.binaryData = binaryData;
        this.type = type;
        this.persistenceId = Screenshot.createPersistenceId(prefix, binaryData);
    }

    public byte[] getBinaryData() {
        return this.binaryData;
    }

    public void setBinaryData(byte[] binaryData) {
        this.binaryData = binaryData;
    }

    public ImageType getType() {
        return this.type;
    }

    public String getPersistenceId() {
        return this.persistenceId;
    }

    public static String createPersistenceId(String prefix, byte[] binaryData) {
        if (prefix.length() > 64) {
            throw new RuntimeException("prefix (" + prefix + ") looks like a full persistenceId");
        }
        return prefix + PERSISTENCE_ID_SEPARATOR + ChecksumCalculator.getInstance().sha256(binaryData);
    }

    public static String getPersistenceIdPrefix(String persistenceId) {
        return persistenceId.replaceAll(REGEX_PREFIX_EXTRACT, "");
    }

    public String getPersistenceIdPrefix() {
        return Screenshot.getPersistenceIdPrefix(this.persistenceId);
    }

    public int hashCode() {
        return this.type.hashCode() * 31 + this.persistenceId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Screenshot)) {
            return false;
        }
        Screenshot other = (Screenshot)obj;
        if (this.type != other.type) {
            return false;
        }
        return this.persistenceId.equals(other.persistenceId);
    }

    public String toString() {
        return "Screenshot of " + this.getPersistenceIdPrefix();
    }

    public static enum ImageType {
        PNG;


        public String getFileExtension() {
            return this.name().toLowerCase();
        }
    }
}

