/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.review;

import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.review.AttributeChanges;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ActionChangeSet {
    private final String description;
    private final String stateFilePath;
    private final AttributeChanges identAttributeChanges = new AttributeChanges();
    private final AttributeChanges attributeChanges = new AttributeChanges();
    private final Set<Element> insertChanges = new HashSet<Element>();
    private final Set<IdentifyingAttributes> deletedChanges = new HashSet<IdentifyingAttributes>();

    public ActionChangeSet() {
        this(null, null);
    }

    public ActionChangeSet(String description, String stateFilePath) {
        this.description = description;
        this.stateFilePath = stateFilePath;
    }

    public AttributeChanges getIdentAttributeChanges() {
        return this.identAttributeChanges;
    }

    public AttributeChanges getAttributesChanges() {
        return this.attributeChanges;
    }

    public boolean containsInsertChange(Element element) {
        return this.insertChanges.contains(element);
    }

    public void addInsertChange(Element element) {
        this.insertChanges.add(element);
    }

    public void removeInsertChange(Element element) {
        this.insertChanges.remove(element);
    }

    public Set<Element> getInsertedChanges() {
        return Collections.unmodifiableSet(this.insertChanges);
    }

    public boolean containsDeletedChange(IdentifyingAttributes identifyingAttributes) {
        return this.deletedChanges.contains(identifyingAttributes);
    }

    public void addDeletedChange(IdentifyingAttributes identifyingAttributes) {
        this.deletedChanges.add(identifyingAttributes);
    }

    public void removeDeletedChange(IdentifyingAttributes identifyingAttributes) {
        this.deletedChanges.remove(identifyingAttributes);
    }

    public Set<IdentifyingAttributes> getDeletedChanges() {
        return Collections.unmodifiableSet(this.deletedChanges);
    }

    public boolean isEmpty() {
        return this.identAttributeChanges.isEmpty() && this.attributeChanges.isEmpty() && this.insertChanges.isEmpty() && this.deletedChanges.isEmpty();
    }

    private int size() {
        return this.identAttributeChanges.size() + this.attributeChanges.size() + this.insertChanges.size() + this.deletedChanges.size();
    }

    public String toString() {
        return "ActionChangeSet [" + this.size() + " changes]";
    }

    public String getDescription() {
        return this.description;
    }

    public String getStateFilePath() {
        return this.stateFilePath;
    }
}

