/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ui.review;

import de.retest.recheck.ui.review.GoldenMasterSource;
import de.retest.recheck.ui.review.TestChangeSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SuiteChangeSet {
    private final ArrayList<TestChangeSet> testChangeSets;
    private final String suiteName;
    private final String uuid;
    private final GoldenMasterSource source;

    SuiteChangeSet(String suiteName, String uuid) {
        this(suiteName, uuid, GoldenMasterSource.RECORDED);
    }

    SuiteChangeSet(String suiteName, String uuid, GoldenMasterSource source) {
        this.suiteName = suiteName;
        this.uuid = uuid;
        this.source = source;
        this.testChangeSets = new ArrayList();
    }

    public TestChangeSet createTestChangeSet() {
        TestChangeSet testChangeSet = new TestChangeSet();
        this.testChangeSets.add(testChangeSet);
        return testChangeSet;
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    public String getUuid() {
        return this.uuid;
    }

    public TestChangeSet getTestChangeSet(int index) {
        TestChangeSet testChangeSet = this.testChangeSets.get(index);
        if (testChangeSet == null || testChangeSet.isEmpty()) {
            return null;
        }
        return testChangeSet;
    }

    public boolean isEmpty() {
        for (TestChangeSet testChangeSet : this.testChangeSets) {
            if (testChangeSet.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public GoldenMasterSource getGoldenMasterSource() {
        return this.source;
    }

    public List<TestChangeSet> getTestChangeSets() {
        return Collections.unmodifiableList(this.testChangeSets);
    }
}

